/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.computeoptimizer.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.computeoptimizer.model.RDSDBRecommendationFilter;
import com.amazonaws.services.computeoptimizer.model.RecommendationPreferences;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GetRDSDatabaseRecommendationsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private List<String> resourceArns;
    private String nextToken;
    private Integer maxResults;
    private List<RDSDBRecommendationFilter> filters;
    private List<String> accountIds;
    private RecommendationPreferences recommendationPreferences;

    public List<String> getResourceArns() {
        return this.resourceArns;
    }

    public void setResourceArns(Collection<String> resourceArns) {
        if (resourceArns == null) {
            this.resourceArns = null;
            return;
        }
        this.resourceArns = new ArrayList<String>(resourceArns);
    }

    public GetRDSDatabaseRecommendationsRequest withResourceArns(String ... resourceArns) {
        if (this.resourceArns == null) {
            this.setResourceArns(new ArrayList<String>(resourceArns.length));
        }
        for (String ele : resourceArns) {
            this.resourceArns.add(ele);
        }
        return this;
    }

    public GetRDSDatabaseRecommendationsRequest withResourceArns(Collection<String> resourceArns) {
        this.setResourceArns(resourceArns);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public GetRDSDatabaseRecommendationsRequest withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public GetRDSDatabaseRecommendationsRequest withMaxResults(Integer maxResults) {
        this.setMaxResults(maxResults);
        return this;
    }

    public List<RDSDBRecommendationFilter> getFilters() {
        return this.filters;
    }

    public void setFilters(Collection<RDSDBRecommendationFilter> filters) {
        if (filters == null) {
            this.filters = null;
            return;
        }
        this.filters = new ArrayList<RDSDBRecommendationFilter>(filters);
    }

    public GetRDSDatabaseRecommendationsRequest withFilters(RDSDBRecommendationFilter ... filters) {
        if (this.filters == null) {
            this.setFilters(new ArrayList<RDSDBRecommendationFilter>(filters.length));
        }
        for (RDSDBRecommendationFilter ele : filters) {
            this.filters.add(ele);
        }
        return this;
    }

    public GetRDSDatabaseRecommendationsRequest withFilters(Collection<RDSDBRecommendationFilter> filters) {
        this.setFilters(filters);
        return this;
    }

    public List<String> getAccountIds() {
        return this.accountIds;
    }

    public void setAccountIds(Collection<String> accountIds) {
        if (accountIds == null) {
            this.accountIds = null;
            return;
        }
        this.accountIds = new ArrayList<String>(accountIds);
    }

    public GetRDSDatabaseRecommendationsRequest withAccountIds(String ... accountIds) {
        if (this.accountIds == null) {
            this.setAccountIds(new ArrayList<String>(accountIds.length));
        }
        for (String ele : accountIds) {
            this.accountIds.add(ele);
        }
        return this;
    }

    public GetRDSDatabaseRecommendationsRequest withAccountIds(Collection<String> accountIds) {
        this.setAccountIds(accountIds);
        return this;
    }

    public void setRecommendationPreferences(RecommendationPreferences recommendationPreferences) {
        this.recommendationPreferences = recommendationPreferences;
    }

    public RecommendationPreferences getRecommendationPreferences() {
        return this.recommendationPreferences;
    }

    public GetRDSDatabaseRecommendationsRequest withRecommendationPreferences(RecommendationPreferences recommendationPreferences) {
        this.setRecommendationPreferences(recommendationPreferences);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getResourceArns() != null) {
            sb.append("ResourceArns: ").append(this.getResourceArns()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getMaxResults() != null) {
            sb.append("MaxResults: ").append(this.getMaxResults()).append(",");
        }
        if (this.getFilters() != null) {
            sb.append("Filters: ").append(this.getFilters()).append(",");
        }
        if (this.getAccountIds() != null) {
            sb.append("AccountIds: ").append(this.getAccountIds()).append(",");
        }
        if (this.getRecommendationPreferences() != null) {
            sb.append("RecommendationPreferences: ").append(this.getRecommendationPreferences());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRDSDatabaseRecommendationsRequest)) {
            return false;
        }
        GetRDSDatabaseRecommendationsRequest other = (GetRDSDatabaseRecommendationsRequest)obj;
        if (other.getResourceArns() == null ^ this.getResourceArns() == null) {
            return false;
        }
        if (other.getResourceArns() != null && !other.getResourceArns().equals(this.getResourceArns())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getMaxResults() == null ^ this.getMaxResults() == null) {
            return false;
        }
        if (other.getMaxResults() != null && !other.getMaxResults().equals(this.getMaxResults())) {
            return false;
        }
        if (other.getFilters() == null ^ this.getFilters() == null) {
            return false;
        }
        if (other.getFilters() != null && !other.getFilters().equals(this.getFilters())) {
            return false;
        }
        if (other.getAccountIds() == null ^ this.getAccountIds() == null) {
            return false;
        }
        if (other.getAccountIds() != null && !other.getAccountIds().equals(this.getAccountIds())) {
            return false;
        }
        if (other.getRecommendationPreferences() == null ^ this.getRecommendationPreferences() == null) {
            return false;
        }
        return other.getRecommendationPreferences() == null || other.getRecommendationPreferences().equals(this.getRecommendationPreferences());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getResourceArns() == null ? 0 : this.getResourceArns().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getMaxResults() == null ? 0 : this.getMaxResults().hashCode());
        hashCode = 31 * hashCode + (this.getFilters() == null ? 0 : this.getFilters().hashCode());
        hashCode = 31 * hashCode + (this.getAccountIds() == null ? 0 : this.getAccountIds().hashCode());
        hashCode = 31 * hashCode + (this.getRecommendationPreferences() == null ? 0 : this.getRecommendationPreferences().hashCode());
        return hashCode;
    }

    public GetRDSDatabaseRecommendationsRequest clone() {
        return (GetRDSDatabaseRecommendationsRequest)super.clone();
    }
}

