/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.computeoptimizer.model.transform;

import java.math.*;

import javax.annotation.Generated;

import com.amazonaws.services.computeoptimizer.model.*;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers.*;
import com.amazonaws.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * RecommendationPreferencesDetail JSON Unmarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class RecommendationPreferencesDetailJsonUnmarshaller implements Unmarshaller<RecommendationPreferencesDetail, JsonUnmarshallerContext> {

    public RecommendationPreferencesDetail unmarshall(JsonUnmarshallerContext context) throws Exception {
        RecommendationPreferencesDetail recommendationPreferencesDetail = new RecommendationPreferencesDetail();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("scope", targetDepth)) {
                    context.nextToken();
                    recommendationPreferencesDetail.setScope(ScopeJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("resourceType", targetDepth)) {
                    context.nextToken();
                    recommendationPreferencesDetail.setResourceType(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("enhancedInfrastructureMetrics", targetDepth)) {
                    context.nextToken();
                    recommendationPreferencesDetail.setEnhancedInfrastructureMetrics(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("inferredWorkloadTypes", targetDepth)) {
                    context.nextToken();
                    recommendationPreferencesDetail.setInferredWorkloadTypes(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("externalMetricsPreference", targetDepth)) {
                    context.nextToken();
                    recommendationPreferencesDetail.setExternalMetricsPreference(ExternalMetricsPreferenceJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("lookBackPeriod", targetDepth)) {
                    context.nextToken();
                    recommendationPreferencesDetail.setLookBackPeriod(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("utilizationPreferences", targetDepth)) {
                    context.nextToken();
                    recommendationPreferencesDetail.setUtilizationPreferences(new ListUnmarshaller<UtilizationPreference>(UtilizationPreferenceJsonUnmarshaller
                            .getInstance())

                    .unmarshall(context));
                }
                if (context.testExpression("preferredResources", targetDepth)) {
                    context.nextToken();
                    recommendationPreferencesDetail.setPreferredResources(new ListUnmarshaller<EffectivePreferredResource>(
                            EffectivePreferredResourceJsonUnmarshaller.getInstance())

                    .unmarshall(context));
                }
                if (context.testExpression("savingsEstimationMode", targetDepth)) {
                    context.nextToken();
                    recommendationPreferencesDetail.setSavingsEstimationMode(context.getUnmarshaller(String.class).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return recommendationPreferencesDetail;
    }

    private static RecommendationPreferencesDetailJsonUnmarshaller instance;

    public static RecommendationPreferencesDetailJsonUnmarshaller getInstance() {
        if (instance == null)
            instance = new RecommendationPreferencesDetailJsonUnmarshaller();
        return instance;
    }
}
