/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.computeoptimizer.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.computeoptimizer.model.GetRecommendationError;
import com.amazonaws.services.computeoptimizer.model.InstanceRecommendation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GetEC2InstanceRecommendationsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String nextToken;
    private List<InstanceRecommendation> instanceRecommendations;
    private List<GetRecommendationError> errors;

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public GetEC2InstanceRecommendationsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public List<InstanceRecommendation> getInstanceRecommendations() {
        return this.instanceRecommendations;
    }

    public void setInstanceRecommendations(Collection<InstanceRecommendation> instanceRecommendations) {
        if (instanceRecommendations == null) {
            this.instanceRecommendations = null;
            return;
        }
        this.instanceRecommendations = new ArrayList<InstanceRecommendation>(instanceRecommendations);
    }

    public GetEC2InstanceRecommendationsResult withInstanceRecommendations(InstanceRecommendation ... instanceRecommendations) {
        if (this.instanceRecommendations == null) {
            this.setInstanceRecommendations(new ArrayList<InstanceRecommendation>(instanceRecommendations.length));
        }
        for (InstanceRecommendation ele : instanceRecommendations) {
            this.instanceRecommendations.add(ele);
        }
        return this;
    }

    public GetEC2InstanceRecommendationsResult withInstanceRecommendations(Collection<InstanceRecommendation> instanceRecommendations) {
        this.setInstanceRecommendations(instanceRecommendations);
        return this;
    }

    public List<GetRecommendationError> getErrors() {
        return this.errors;
    }

    public void setErrors(Collection<GetRecommendationError> errors) {
        if (errors == null) {
            this.errors = null;
            return;
        }
        this.errors = new ArrayList<GetRecommendationError>(errors);
    }

    public GetEC2InstanceRecommendationsResult withErrors(GetRecommendationError ... errors) {
        if (this.errors == null) {
            this.setErrors(new ArrayList<GetRecommendationError>(errors.length));
        }
        for (GetRecommendationError ele : errors) {
            this.errors.add(ele);
        }
        return this;
    }

    public GetEC2InstanceRecommendationsResult withErrors(Collection<GetRecommendationError> errors) {
        this.setErrors(errors);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getInstanceRecommendations() != null) {
            sb.append("InstanceRecommendations: ").append(this.getInstanceRecommendations()).append(",");
        }
        if (this.getErrors() != null) {
            sb.append("Errors: ").append(this.getErrors());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEC2InstanceRecommendationsResult)) {
            return false;
        }
        GetEC2InstanceRecommendationsResult other = (GetEC2InstanceRecommendationsResult)obj;
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getInstanceRecommendations() == null ^ this.getInstanceRecommendations() == null) {
            return false;
        }
        if (other.getInstanceRecommendations() != null && !other.getInstanceRecommendations().equals(this.getInstanceRecommendations())) {
            return false;
        }
        if (other.getErrors() == null ^ this.getErrors() == null) {
            return false;
        }
        return other.getErrors() == null || other.getErrors().equals(this.getErrors());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceRecommendations() == null ? 0 : this.getInstanceRecommendations().hashCode());
        hashCode = 31 * hashCode + (this.getErrors() == null ? 0 : this.getErrors().hashCode());
        return hashCode;
    }

    public GetEC2InstanceRecommendationsResult clone() {
        try {
            return (GetEC2InstanceRecommendationsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

