/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.computeoptimizer.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.computeoptimizer.model.Finding;
import com.amazonaws.services.computeoptimizer.model.ReasonCodeSummary;
import com.amazonaws.services.computeoptimizer.model.transform.SummaryMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Summary
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private Double value;
    private List<ReasonCodeSummary> reasonCodeSummaries;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Summary withName(String name) {
        this.setName(name);
        return this;
    }

    public Summary withName(Finding name) {
        this.name = name.toString();
        return this;
    }

    public void setValue(Double value) {
        this.value = value;
    }

    public Double getValue() {
        return this.value;
    }

    public Summary withValue(Double value) {
        this.setValue(value);
        return this;
    }

    public List<ReasonCodeSummary> getReasonCodeSummaries() {
        return this.reasonCodeSummaries;
    }

    public void setReasonCodeSummaries(Collection<ReasonCodeSummary> reasonCodeSummaries) {
        if (reasonCodeSummaries == null) {
            this.reasonCodeSummaries = null;
            return;
        }
        this.reasonCodeSummaries = new ArrayList<ReasonCodeSummary>(reasonCodeSummaries);
    }

    public Summary withReasonCodeSummaries(ReasonCodeSummary ... reasonCodeSummaries) {
        if (this.reasonCodeSummaries == null) {
            this.setReasonCodeSummaries(new ArrayList<ReasonCodeSummary>(reasonCodeSummaries.length));
        }
        for (ReasonCodeSummary ele : reasonCodeSummaries) {
            this.reasonCodeSummaries.add(ele);
        }
        return this;
    }

    public Summary withReasonCodeSummaries(Collection<ReasonCodeSummary> reasonCodeSummaries) {
        this.setReasonCodeSummaries(reasonCodeSummaries);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getValue() != null) {
            sb.append("Value: ").append(this.getValue()).append(",");
        }
        if (this.getReasonCodeSummaries() != null) {
            sb.append("ReasonCodeSummaries: ").append(this.getReasonCodeSummaries());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Summary)) {
            return false;
        }
        Summary other = (Summary)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getValue() == null ^ this.getValue() == null) {
            return false;
        }
        if (other.getValue() != null && !other.getValue().equals(this.getValue())) {
            return false;
        }
        if (other.getReasonCodeSummaries() == null ^ this.getReasonCodeSummaries() == null) {
            return false;
        }
        return other.getReasonCodeSummaries() == null || other.getReasonCodeSummaries().equals(this.getReasonCodeSummaries());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getValue() == null ? 0 : this.getValue().hashCode());
        hashCode = 31 * hashCode + (this.getReasonCodeSummaries() == null ? 0 : this.getReasonCodeSummaries().hashCode());
        return hashCode;
    }

    public Summary clone() {
        try {
            return (Summary)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

