/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.computeoptimizer.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.computeoptimizer.model.LambdaFunctionMemoryRecommendationOption;
import com.amazonaws.services.computeoptimizer.model.LambdaFunctionRecommendationFinding;
import com.amazonaws.services.computeoptimizer.model.LambdaFunctionRecommendationFindingReasonCode;
import com.amazonaws.services.computeoptimizer.model.LambdaFunctionUtilizationMetric;
import com.amazonaws.services.computeoptimizer.model.transform.LambdaFunctionRecommendationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class LambdaFunctionRecommendation
implements Serializable,
Cloneable,
StructuredPojo {
    private String functionArn;
    private String functionVersion;
    private String accountId;
    private Integer currentMemorySize;
    private Long numberOfInvocations;
    private List<LambdaFunctionUtilizationMetric> utilizationMetrics;
    private Double lookbackPeriodInDays;
    private Date lastRefreshTimestamp;
    private String finding;
    private List<String> findingReasonCodes;
    private List<LambdaFunctionMemoryRecommendationOption> memorySizeRecommendationOptions;

    public void setFunctionArn(String functionArn) {
        this.functionArn = functionArn;
    }

    public String getFunctionArn() {
        return this.functionArn;
    }

    public LambdaFunctionRecommendation withFunctionArn(String functionArn) {
        this.setFunctionArn(functionArn);
        return this;
    }

    public void setFunctionVersion(String functionVersion) {
        this.functionVersion = functionVersion;
    }

    public String getFunctionVersion() {
        return this.functionVersion;
    }

    public LambdaFunctionRecommendation withFunctionVersion(String functionVersion) {
        this.setFunctionVersion(functionVersion);
        return this;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public LambdaFunctionRecommendation withAccountId(String accountId) {
        this.setAccountId(accountId);
        return this;
    }

    public void setCurrentMemorySize(Integer currentMemorySize) {
        this.currentMemorySize = currentMemorySize;
    }

    public Integer getCurrentMemorySize() {
        return this.currentMemorySize;
    }

    public LambdaFunctionRecommendation withCurrentMemorySize(Integer currentMemorySize) {
        this.setCurrentMemorySize(currentMemorySize);
        return this;
    }

    public void setNumberOfInvocations(Long numberOfInvocations) {
        this.numberOfInvocations = numberOfInvocations;
    }

    public Long getNumberOfInvocations() {
        return this.numberOfInvocations;
    }

    public LambdaFunctionRecommendation withNumberOfInvocations(Long numberOfInvocations) {
        this.setNumberOfInvocations(numberOfInvocations);
        return this;
    }

    public List<LambdaFunctionUtilizationMetric> getUtilizationMetrics() {
        return this.utilizationMetrics;
    }

    public void setUtilizationMetrics(Collection<LambdaFunctionUtilizationMetric> utilizationMetrics) {
        if (utilizationMetrics == null) {
            this.utilizationMetrics = null;
            return;
        }
        this.utilizationMetrics = new ArrayList<LambdaFunctionUtilizationMetric>(utilizationMetrics);
    }

    public LambdaFunctionRecommendation withUtilizationMetrics(LambdaFunctionUtilizationMetric ... utilizationMetrics) {
        if (this.utilizationMetrics == null) {
            this.setUtilizationMetrics(new ArrayList<LambdaFunctionUtilizationMetric>(utilizationMetrics.length));
        }
        for (LambdaFunctionUtilizationMetric ele : utilizationMetrics) {
            this.utilizationMetrics.add(ele);
        }
        return this;
    }

    public LambdaFunctionRecommendation withUtilizationMetrics(Collection<LambdaFunctionUtilizationMetric> utilizationMetrics) {
        this.setUtilizationMetrics(utilizationMetrics);
        return this;
    }

    public void setLookbackPeriodInDays(Double lookbackPeriodInDays) {
        this.lookbackPeriodInDays = lookbackPeriodInDays;
    }

    public Double getLookbackPeriodInDays() {
        return this.lookbackPeriodInDays;
    }

    public LambdaFunctionRecommendation withLookbackPeriodInDays(Double lookbackPeriodInDays) {
        this.setLookbackPeriodInDays(lookbackPeriodInDays);
        return this;
    }

    public void setLastRefreshTimestamp(Date lastRefreshTimestamp) {
        this.lastRefreshTimestamp = lastRefreshTimestamp;
    }

    public Date getLastRefreshTimestamp() {
        return this.lastRefreshTimestamp;
    }

    public LambdaFunctionRecommendation withLastRefreshTimestamp(Date lastRefreshTimestamp) {
        this.setLastRefreshTimestamp(lastRefreshTimestamp);
        return this;
    }

    public void setFinding(String finding) {
        this.finding = finding;
    }

    public String getFinding() {
        return this.finding;
    }

    public LambdaFunctionRecommendation withFinding(String finding) {
        this.setFinding(finding);
        return this;
    }

    public LambdaFunctionRecommendation withFinding(LambdaFunctionRecommendationFinding finding) {
        this.finding = finding.toString();
        return this;
    }

    public List<String> getFindingReasonCodes() {
        return this.findingReasonCodes;
    }

    public void setFindingReasonCodes(Collection<String> findingReasonCodes) {
        if (findingReasonCodes == null) {
            this.findingReasonCodes = null;
            return;
        }
        this.findingReasonCodes = new ArrayList<String>(findingReasonCodes);
    }

    public LambdaFunctionRecommendation withFindingReasonCodes(String ... findingReasonCodes) {
        if (this.findingReasonCodes == null) {
            this.setFindingReasonCodes(new ArrayList<String>(findingReasonCodes.length));
        }
        for (String ele : findingReasonCodes) {
            this.findingReasonCodes.add(ele);
        }
        return this;
    }

    public LambdaFunctionRecommendation withFindingReasonCodes(Collection<String> findingReasonCodes) {
        this.setFindingReasonCodes(findingReasonCodes);
        return this;
    }

    public LambdaFunctionRecommendation withFindingReasonCodes(LambdaFunctionRecommendationFindingReasonCode ... findingReasonCodes) {
        ArrayList<String> findingReasonCodesCopy = new ArrayList<String>(findingReasonCodes.length);
        for (LambdaFunctionRecommendationFindingReasonCode value : findingReasonCodes) {
            findingReasonCodesCopy.add(value.toString());
        }
        if (this.getFindingReasonCodes() == null) {
            this.setFindingReasonCodes(findingReasonCodesCopy);
        } else {
            this.getFindingReasonCodes().addAll(findingReasonCodesCopy);
        }
        return this;
    }

    public List<LambdaFunctionMemoryRecommendationOption> getMemorySizeRecommendationOptions() {
        return this.memorySizeRecommendationOptions;
    }

    public void setMemorySizeRecommendationOptions(Collection<LambdaFunctionMemoryRecommendationOption> memorySizeRecommendationOptions) {
        if (memorySizeRecommendationOptions == null) {
            this.memorySizeRecommendationOptions = null;
            return;
        }
        this.memorySizeRecommendationOptions = new ArrayList<LambdaFunctionMemoryRecommendationOption>(memorySizeRecommendationOptions);
    }

    public LambdaFunctionRecommendation withMemorySizeRecommendationOptions(LambdaFunctionMemoryRecommendationOption ... memorySizeRecommendationOptions) {
        if (this.memorySizeRecommendationOptions == null) {
            this.setMemorySizeRecommendationOptions(new ArrayList<LambdaFunctionMemoryRecommendationOption>(memorySizeRecommendationOptions.length));
        }
        for (LambdaFunctionMemoryRecommendationOption ele : memorySizeRecommendationOptions) {
            this.memorySizeRecommendationOptions.add(ele);
        }
        return this;
    }

    public LambdaFunctionRecommendation withMemorySizeRecommendationOptions(Collection<LambdaFunctionMemoryRecommendationOption> memorySizeRecommendationOptions) {
        this.setMemorySizeRecommendationOptions(memorySizeRecommendationOptions);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFunctionArn() != null) {
            sb.append("FunctionArn: ").append(this.getFunctionArn()).append(",");
        }
        if (this.getFunctionVersion() != null) {
            sb.append("FunctionVersion: ").append(this.getFunctionVersion()).append(",");
        }
        if (this.getAccountId() != null) {
            sb.append("AccountId: ").append(this.getAccountId()).append(",");
        }
        if (this.getCurrentMemorySize() != null) {
            sb.append("CurrentMemorySize: ").append(this.getCurrentMemorySize()).append(",");
        }
        if (this.getNumberOfInvocations() != null) {
            sb.append("NumberOfInvocations: ").append(this.getNumberOfInvocations()).append(",");
        }
        if (this.getUtilizationMetrics() != null) {
            sb.append("UtilizationMetrics: ").append(this.getUtilizationMetrics()).append(",");
        }
        if (this.getLookbackPeriodInDays() != null) {
            sb.append("LookbackPeriodInDays: ").append(this.getLookbackPeriodInDays()).append(",");
        }
        if (this.getLastRefreshTimestamp() != null) {
            sb.append("LastRefreshTimestamp: ").append(this.getLastRefreshTimestamp()).append(",");
        }
        if (this.getFinding() != null) {
            sb.append("Finding: ").append(this.getFinding()).append(",");
        }
        if (this.getFindingReasonCodes() != null) {
            sb.append("FindingReasonCodes: ").append(this.getFindingReasonCodes()).append(",");
        }
        if (this.getMemorySizeRecommendationOptions() != null) {
            sb.append("MemorySizeRecommendationOptions: ").append(this.getMemorySizeRecommendationOptions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LambdaFunctionRecommendation)) {
            return false;
        }
        LambdaFunctionRecommendation other = (LambdaFunctionRecommendation)obj;
        if (other.getFunctionArn() == null ^ this.getFunctionArn() == null) {
            return false;
        }
        if (other.getFunctionArn() != null && !other.getFunctionArn().equals(this.getFunctionArn())) {
            return false;
        }
        if (other.getFunctionVersion() == null ^ this.getFunctionVersion() == null) {
            return false;
        }
        if (other.getFunctionVersion() != null && !other.getFunctionVersion().equals(this.getFunctionVersion())) {
            return false;
        }
        if (other.getAccountId() == null ^ this.getAccountId() == null) {
            return false;
        }
        if (other.getAccountId() != null && !other.getAccountId().equals(this.getAccountId())) {
            return false;
        }
        if (other.getCurrentMemorySize() == null ^ this.getCurrentMemorySize() == null) {
            return false;
        }
        if (other.getCurrentMemorySize() != null && !other.getCurrentMemorySize().equals(this.getCurrentMemorySize())) {
            return false;
        }
        if (other.getNumberOfInvocations() == null ^ this.getNumberOfInvocations() == null) {
            return false;
        }
        if (other.getNumberOfInvocations() != null && !other.getNumberOfInvocations().equals(this.getNumberOfInvocations())) {
            return false;
        }
        if (other.getUtilizationMetrics() == null ^ this.getUtilizationMetrics() == null) {
            return false;
        }
        if (other.getUtilizationMetrics() != null && !other.getUtilizationMetrics().equals(this.getUtilizationMetrics())) {
            return false;
        }
        if (other.getLookbackPeriodInDays() == null ^ this.getLookbackPeriodInDays() == null) {
            return false;
        }
        if (other.getLookbackPeriodInDays() != null && !other.getLookbackPeriodInDays().equals(this.getLookbackPeriodInDays())) {
            return false;
        }
        if (other.getLastRefreshTimestamp() == null ^ this.getLastRefreshTimestamp() == null) {
            return false;
        }
        if (other.getLastRefreshTimestamp() != null && !other.getLastRefreshTimestamp().equals(this.getLastRefreshTimestamp())) {
            return false;
        }
        if (other.getFinding() == null ^ this.getFinding() == null) {
            return false;
        }
        if (other.getFinding() != null && !other.getFinding().equals(this.getFinding())) {
            return false;
        }
        if (other.getFindingReasonCodes() == null ^ this.getFindingReasonCodes() == null) {
            return false;
        }
        if (other.getFindingReasonCodes() != null && !other.getFindingReasonCodes().equals(this.getFindingReasonCodes())) {
            return false;
        }
        if (other.getMemorySizeRecommendationOptions() == null ^ this.getMemorySizeRecommendationOptions() == null) {
            return false;
        }
        return other.getMemorySizeRecommendationOptions() == null || other.getMemorySizeRecommendationOptions().equals(this.getMemorySizeRecommendationOptions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFunctionArn() == null ? 0 : this.getFunctionArn().hashCode());
        hashCode = 31 * hashCode + (this.getFunctionVersion() == null ? 0 : this.getFunctionVersion().hashCode());
        hashCode = 31 * hashCode + (this.getAccountId() == null ? 0 : this.getAccountId().hashCode());
        hashCode = 31 * hashCode + (this.getCurrentMemorySize() == null ? 0 : this.getCurrentMemorySize().hashCode());
        hashCode = 31 * hashCode + (this.getNumberOfInvocations() == null ? 0 : this.getNumberOfInvocations().hashCode());
        hashCode = 31 * hashCode + (this.getUtilizationMetrics() == null ? 0 : this.getUtilizationMetrics().hashCode());
        hashCode = 31 * hashCode + (this.getLookbackPeriodInDays() == null ? 0 : this.getLookbackPeriodInDays().hashCode());
        hashCode = 31 * hashCode + (this.getLastRefreshTimestamp() == null ? 0 : this.getLastRefreshTimestamp().hashCode());
        hashCode = 31 * hashCode + (this.getFinding() == null ? 0 : this.getFinding().hashCode());
        hashCode = 31 * hashCode + (this.getFindingReasonCodes() == null ? 0 : this.getFindingReasonCodes().hashCode());
        hashCode = 31 * hashCode + (this.getMemorySizeRecommendationOptions() == null ? 0 : this.getMemorySizeRecommendationOptions().hashCode());
        return hashCode;
    }

    public LambdaFunctionRecommendation clone() {
        try {
            return (LambdaFunctionRecommendation)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LambdaFunctionRecommendationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

