/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.comprehend.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.comprehend.model.BlockReference;
import com.amazonaws.services.comprehend.model.EntityType;
import com.amazonaws.services.comprehend.model.transform.EntityMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Entity
implements Serializable,
Cloneable,
StructuredPojo {
    private Float score;
    private String type;
    private String text;
    private Integer beginOffset;
    private Integer endOffset;
    private List<BlockReference> blockReferences;

    public void setScore(Float score) {
        this.score = score;
    }

    public Float getScore() {
        return this.score;
    }

    public Entity withScore(Float score) {
        this.setScore(score);
        return this;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public Entity withType(String type) {
        this.setType(type);
        return this;
    }

    public Entity withType(EntityType type) {
        this.type = type.toString();
        return this;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    public Entity withText(String text) {
        this.setText(text);
        return this;
    }

    public void setBeginOffset(Integer beginOffset) {
        this.beginOffset = beginOffset;
    }

    public Integer getBeginOffset() {
        return this.beginOffset;
    }

    public Entity withBeginOffset(Integer beginOffset) {
        this.setBeginOffset(beginOffset);
        return this;
    }

    public void setEndOffset(Integer endOffset) {
        this.endOffset = endOffset;
    }

    public Integer getEndOffset() {
        return this.endOffset;
    }

    public Entity withEndOffset(Integer endOffset) {
        this.setEndOffset(endOffset);
        return this;
    }

    public List<BlockReference> getBlockReferences() {
        return this.blockReferences;
    }

    public void setBlockReferences(Collection<BlockReference> blockReferences) {
        if (blockReferences == null) {
            this.blockReferences = null;
            return;
        }
        this.blockReferences = new ArrayList<BlockReference>(blockReferences);
    }

    public Entity withBlockReferences(BlockReference ... blockReferences) {
        if (this.blockReferences == null) {
            this.setBlockReferences(new ArrayList<BlockReference>(blockReferences.length));
        }
        for (BlockReference ele : blockReferences) {
            this.blockReferences.add(ele);
        }
        return this;
    }

    public Entity withBlockReferences(Collection<BlockReference> blockReferences) {
        this.setBlockReferences(blockReferences);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getScore() != null) {
            sb.append("Score: ").append(this.getScore()).append(",");
        }
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType()).append(",");
        }
        if (this.getText() != null) {
            sb.append("Text: ").append(this.getText()).append(",");
        }
        if (this.getBeginOffset() != null) {
            sb.append("BeginOffset: ").append(this.getBeginOffset()).append(",");
        }
        if (this.getEndOffset() != null) {
            sb.append("EndOffset: ").append(this.getEndOffset()).append(",");
        }
        if (this.getBlockReferences() != null) {
            sb.append("BlockReferences: ").append(this.getBlockReferences());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Entity)) {
            return false;
        }
        Entity other = (Entity)obj;
        if (other.getScore() == null ^ this.getScore() == null) {
            return false;
        }
        if (other.getScore() != null && !other.getScore().equals(this.getScore())) {
            return false;
        }
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getText() == null ^ this.getText() == null) {
            return false;
        }
        if (other.getText() != null && !other.getText().equals(this.getText())) {
            return false;
        }
        if (other.getBeginOffset() == null ^ this.getBeginOffset() == null) {
            return false;
        }
        if (other.getBeginOffset() != null && !other.getBeginOffset().equals(this.getBeginOffset())) {
            return false;
        }
        if (other.getEndOffset() == null ^ this.getEndOffset() == null) {
            return false;
        }
        if (other.getEndOffset() != null && !other.getEndOffset().equals(this.getEndOffset())) {
            return false;
        }
        if (other.getBlockReferences() == null ^ this.getBlockReferences() == null) {
            return false;
        }
        return other.getBlockReferences() == null || other.getBlockReferences().equals(this.getBlockReferences());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getScore() == null ? 0 : this.getScore().hashCode());
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getText() == null ? 0 : this.getText().hashCode());
        hashCode = 31 * hashCode + (this.getBeginOffset() == null ? 0 : this.getBeginOffset().hashCode());
        hashCode = 31 * hashCode + (this.getEndOffset() == null ? 0 : this.getEndOffset().hashCode());
        hashCode = 31 * hashCode + (this.getBlockReferences() == null ? 0 : this.getBlockReferences().hashCode());
        return hashCode;
    }

    public Entity clone() {
        try {
            return (Entity)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EntityMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

