/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.comprehend.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.comprehend.model.Block;
import com.amazonaws.services.comprehend.model.DocumentMetadata;
import com.amazonaws.services.comprehend.model.DocumentTypeListItem;
import com.amazonaws.services.comprehend.model.Entity;
import com.amazonaws.services.comprehend.model.ErrorsListItem;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DetectEntitiesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<Entity> entities;
    private DocumentMetadata documentMetadata;
    private List<DocumentTypeListItem> documentType;
    private List<Block> blocks;
    private List<ErrorsListItem> errors;

    public List<Entity> getEntities() {
        return this.entities;
    }

    public void setEntities(Collection<Entity> entities) {
        if (entities == null) {
            this.entities = null;
            return;
        }
        this.entities = new ArrayList<Entity>(entities);
    }

    public DetectEntitiesResult withEntities(Entity ... entities) {
        if (this.entities == null) {
            this.setEntities(new ArrayList<Entity>(entities.length));
        }
        for (Entity ele : entities) {
            this.entities.add(ele);
        }
        return this;
    }

    public DetectEntitiesResult withEntities(Collection<Entity> entities) {
        this.setEntities(entities);
        return this;
    }

    public void setDocumentMetadata(DocumentMetadata documentMetadata) {
        this.documentMetadata = documentMetadata;
    }

    public DocumentMetadata getDocumentMetadata() {
        return this.documentMetadata;
    }

    public DetectEntitiesResult withDocumentMetadata(DocumentMetadata documentMetadata) {
        this.setDocumentMetadata(documentMetadata);
        return this;
    }

    public List<DocumentTypeListItem> getDocumentType() {
        return this.documentType;
    }

    public void setDocumentType(Collection<DocumentTypeListItem> documentType) {
        if (documentType == null) {
            this.documentType = null;
            return;
        }
        this.documentType = new ArrayList<DocumentTypeListItem>(documentType);
    }

    public DetectEntitiesResult withDocumentType(DocumentTypeListItem ... documentType) {
        if (this.documentType == null) {
            this.setDocumentType(new ArrayList<DocumentTypeListItem>(documentType.length));
        }
        for (DocumentTypeListItem ele : documentType) {
            this.documentType.add(ele);
        }
        return this;
    }

    public DetectEntitiesResult withDocumentType(Collection<DocumentTypeListItem> documentType) {
        this.setDocumentType(documentType);
        return this;
    }

    public List<Block> getBlocks() {
        return this.blocks;
    }

    public void setBlocks(Collection<Block> blocks) {
        if (blocks == null) {
            this.blocks = null;
            return;
        }
        this.blocks = new ArrayList<Block>(blocks);
    }

    public DetectEntitiesResult withBlocks(Block ... blocks) {
        if (this.blocks == null) {
            this.setBlocks(new ArrayList<Block>(blocks.length));
        }
        for (Block ele : blocks) {
            this.blocks.add(ele);
        }
        return this;
    }

    public DetectEntitiesResult withBlocks(Collection<Block> blocks) {
        this.setBlocks(blocks);
        return this;
    }

    public List<ErrorsListItem> getErrors() {
        return this.errors;
    }

    public void setErrors(Collection<ErrorsListItem> errors) {
        if (errors == null) {
            this.errors = null;
            return;
        }
        this.errors = new ArrayList<ErrorsListItem>(errors);
    }

    public DetectEntitiesResult withErrors(ErrorsListItem ... errors) {
        if (this.errors == null) {
            this.setErrors(new ArrayList<ErrorsListItem>(errors.length));
        }
        for (ErrorsListItem ele : errors) {
            this.errors.add(ele);
        }
        return this;
    }

    public DetectEntitiesResult withErrors(Collection<ErrorsListItem> errors) {
        this.setErrors(errors);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEntities() != null) {
            sb.append("Entities: ").append(this.getEntities()).append(",");
        }
        if (this.getDocumentMetadata() != null) {
            sb.append("DocumentMetadata: ").append(this.getDocumentMetadata()).append(",");
        }
        if (this.getDocumentType() != null) {
            sb.append("DocumentType: ").append(this.getDocumentType()).append(",");
        }
        if (this.getBlocks() != null) {
            sb.append("Blocks: ").append(this.getBlocks()).append(",");
        }
        if (this.getErrors() != null) {
            sb.append("Errors: ").append(this.getErrors());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectEntitiesResult)) {
            return false;
        }
        DetectEntitiesResult other = (DetectEntitiesResult)obj;
        if (other.getEntities() == null ^ this.getEntities() == null) {
            return false;
        }
        if (other.getEntities() != null && !other.getEntities().equals(this.getEntities())) {
            return false;
        }
        if (other.getDocumentMetadata() == null ^ this.getDocumentMetadata() == null) {
            return false;
        }
        if (other.getDocumentMetadata() != null && !other.getDocumentMetadata().equals(this.getDocumentMetadata())) {
            return false;
        }
        if (other.getDocumentType() == null ^ this.getDocumentType() == null) {
            return false;
        }
        if (other.getDocumentType() != null && !other.getDocumentType().equals(this.getDocumentType())) {
            return false;
        }
        if (other.getBlocks() == null ^ this.getBlocks() == null) {
            return false;
        }
        if (other.getBlocks() != null && !other.getBlocks().equals(this.getBlocks())) {
            return false;
        }
        if (other.getErrors() == null ^ this.getErrors() == null) {
            return false;
        }
        return other.getErrors() == null || other.getErrors().equals(this.getErrors());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEntities() == null ? 0 : this.getEntities().hashCode());
        hashCode = 31 * hashCode + (this.getDocumentMetadata() == null ? 0 : this.getDocumentMetadata().hashCode());
        hashCode = 31 * hashCode + (this.getDocumentType() == null ? 0 : this.getDocumentType().hashCode());
        hashCode = 31 * hashCode + (this.getBlocks() == null ? 0 : this.getBlocks().hashCode());
        hashCode = 31 * hashCode + (this.getErrors() == null ? 0 : this.getErrors().hashCode());
        return hashCode;
    }

    public DetectEntitiesResult clone() {
        try {
            return (DetectEntitiesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

