/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.comprehend.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.comprehend.model.ChildBlock;
import com.amazonaws.services.comprehend.model.transform.BlockReferenceMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class BlockReference
implements Serializable,
Cloneable,
StructuredPojo {
    private String blockId;
    private Integer beginOffset;
    private Integer endOffset;
    private List<ChildBlock> childBlocks;

    public void setBlockId(String blockId) {
        this.blockId = blockId;
    }

    public String getBlockId() {
        return this.blockId;
    }

    public BlockReference withBlockId(String blockId) {
        this.setBlockId(blockId);
        return this;
    }

    public void setBeginOffset(Integer beginOffset) {
        this.beginOffset = beginOffset;
    }

    public Integer getBeginOffset() {
        return this.beginOffset;
    }

    public BlockReference withBeginOffset(Integer beginOffset) {
        this.setBeginOffset(beginOffset);
        return this;
    }

    public void setEndOffset(Integer endOffset) {
        this.endOffset = endOffset;
    }

    public Integer getEndOffset() {
        return this.endOffset;
    }

    public BlockReference withEndOffset(Integer endOffset) {
        this.setEndOffset(endOffset);
        return this;
    }

    public List<ChildBlock> getChildBlocks() {
        return this.childBlocks;
    }

    public void setChildBlocks(Collection<ChildBlock> childBlocks) {
        if (childBlocks == null) {
            this.childBlocks = null;
            return;
        }
        this.childBlocks = new ArrayList<ChildBlock>(childBlocks);
    }

    public BlockReference withChildBlocks(ChildBlock ... childBlocks) {
        if (this.childBlocks == null) {
            this.setChildBlocks(new ArrayList<ChildBlock>(childBlocks.length));
        }
        for (ChildBlock ele : childBlocks) {
            this.childBlocks.add(ele);
        }
        return this;
    }

    public BlockReference withChildBlocks(Collection<ChildBlock> childBlocks) {
        this.setChildBlocks(childBlocks);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getBlockId() != null) {
            sb.append("BlockId: ").append(this.getBlockId()).append(",");
        }
        if (this.getBeginOffset() != null) {
            sb.append("BeginOffset: ").append(this.getBeginOffset()).append(",");
        }
        if (this.getEndOffset() != null) {
            sb.append("EndOffset: ").append(this.getEndOffset()).append(",");
        }
        if (this.getChildBlocks() != null) {
            sb.append("ChildBlocks: ").append(this.getChildBlocks());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BlockReference)) {
            return false;
        }
        BlockReference other = (BlockReference)obj;
        if (other.getBlockId() == null ^ this.getBlockId() == null) {
            return false;
        }
        if (other.getBlockId() != null && !other.getBlockId().equals(this.getBlockId())) {
            return false;
        }
        if (other.getBeginOffset() == null ^ this.getBeginOffset() == null) {
            return false;
        }
        if (other.getBeginOffset() != null && !other.getBeginOffset().equals(this.getBeginOffset())) {
            return false;
        }
        if (other.getEndOffset() == null ^ this.getEndOffset() == null) {
            return false;
        }
        if (other.getEndOffset() != null && !other.getEndOffset().equals(this.getEndOffset())) {
            return false;
        }
        if (other.getChildBlocks() == null ^ this.getChildBlocks() == null) {
            return false;
        }
        return other.getChildBlocks() == null || other.getChildBlocks().equals(this.getChildBlocks());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getBlockId() == null ? 0 : this.getBlockId().hashCode());
        hashCode = 31 * hashCode + (this.getBeginOffset() == null ? 0 : this.getBeginOffset().hashCode());
        hashCode = 31 * hashCode + (this.getEndOffset() == null ? 0 : this.getEndOffset().hashCode());
        hashCode = 31 * hashCode + (this.getChildBlocks() == null ? 0 : this.getChildBlocks().hashCode());
        return hashCode;
    }

    public BlockReference clone() {
        try {
            return (BlockReference)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BlockReferenceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

