/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.comprehend.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.comprehend.model.PartOfSpeechTag;
import com.amazonaws.services.comprehend.model.transform.SyntaxTokenMarshaller;
import java.io.Serializable;

public class SyntaxToken
implements Serializable,
Cloneable,
StructuredPojo {
    private Integer tokenId;
    private String text;
    private Integer beginOffset;
    private Integer endOffset;
    private PartOfSpeechTag partOfSpeech;

    public void setTokenId(Integer tokenId) {
        this.tokenId = tokenId;
    }

    public Integer getTokenId() {
        return this.tokenId;
    }

    public SyntaxToken withTokenId(Integer tokenId) {
        this.setTokenId(tokenId);
        return this;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    public SyntaxToken withText(String text) {
        this.setText(text);
        return this;
    }

    public void setBeginOffset(Integer beginOffset) {
        this.beginOffset = beginOffset;
    }

    public Integer getBeginOffset() {
        return this.beginOffset;
    }

    public SyntaxToken withBeginOffset(Integer beginOffset) {
        this.setBeginOffset(beginOffset);
        return this;
    }

    public void setEndOffset(Integer endOffset) {
        this.endOffset = endOffset;
    }

    public Integer getEndOffset() {
        return this.endOffset;
    }

    public SyntaxToken withEndOffset(Integer endOffset) {
        this.setEndOffset(endOffset);
        return this;
    }

    public void setPartOfSpeech(PartOfSpeechTag partOfSpeech) {
        this.partOfSpeech = partOfSpeech;
    }

    public PartOfSpeechTag getPartOfSpeech() {
        return this.partOfSpeech;
    }

    public SyntaxToken withPartOfSpeech(PartOfSpeechTag partOfSpeech) {
        this.setPartOfSpeech(partOfSpeech);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTokenId() != null) {
            sb.append("TokenId: ").append(this.getTokenId()).append(",");
        }
        if (this.getText() != null) {
            sb.append("Text: ").append(this.getText()).append(",");
        }
        if (this.getBeginOffset() != null) {
            sb.append("BeginOffset: ").append(this.getBeginOffset()).append(",");
        }
        if (this.getEndOffset() != null) {
            sb.append("EndOffset: ").append(this.getEndOffset()).append(",");
        }
        if (this.getPartOfSpeech() != null) {
            sb.append("PartOfSpeech: ").append(this.getPartOfSpeech());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SyntaxToken)) {
            return false;
        }
        SyntaxToken other = (SyntaxToken)obj;
        if (other.getTokenId() == null ^ this.getTokenId() == null) {
            return false;
        }
        if (other.getTokenId() != null && !other.getTokenId().equals(this.getTokenId())) {
            return false;
        }
        if (other.getText() == null ^ this.getText() == null) {
            return false;
        }
        if (other.getText() != null && !other.getText().equals(this.getText())) {
            return false;
        }
        if (other.getBeginOffset() == null ^ this.getBeginOffset() == null) {
            return false;
        }
        if (other.getBeginOffset() != null && !other.getBeginOffset().equals(this.getBeginOffset())) {
            return false;
        }
        if (other.getEndOffset() == null ^ this.getEndOffset() == null) {
            return false;
        }
        if (other.getEndOffset() != null && !other.getEndOffset().equals(this.getEndOffset())) {
            return false;
        }
        if (other.getPartOfSpeech() == null ^ this.getPartOfSpeech() == null) {
            return false;
        }
        return other.getPartOfSpeech() == null || other.getPartOfSpeech().equals(this.getPartOfSpeech());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTokenId() == null ? 0 : this.getTokenId().hashCode());
        hashCode = 31 * hashCode + (this.getText() == null ? 0 : this.getText().hashCode());
        hashCode = 31 * hashCode + (this.getBeginOffset() == null ? 0 : this.getBeginOffset().hashCode());
        hashCode = 31 * hashCode + (this.getEndOffset() == null ? 0 : this.getEndOffset().hashCode());
        hashCode = 31 * hashCode + (this.getPartOfSpeech() == null ? 0 : this.getPartOfSpeech().hashCode());
        return hashCode;
    }

    public SyntaxToken clone() {
        try {
            return (SyntaxToken)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SyntaxTokenMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

