/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.comprehend;

import javax.annotation.Generated;

import com.amazonaws.services.comprehend.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AmazonComprehend}. Convenient method forms pass through to the corresponding
 * overload that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAmazonComprehend implements AmazonComprehend {

    protected AbstractAmazonComprehend() {
    }

    @Override
    public BatchDetectDominantLanguageResult batchDetectDominantLanguage(BatchDetectDominantLanguageRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public BatchDetectEntitiesResult batchDetectEntities(BatchDetectEntitiesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public BatchDetectKeyPhrasesResult batchDetectKeyPhrases(BatchDetectKeyPhrasesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public BatchDetectSentimentResult batchDetectSentiment(BatchDetectSentimentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public BatchDetectSyntaxResult batchDetectSyntax(BatchDetectSyntaxRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateDocumentClassifierResult createDocumentClassifier(CreateDocumentClassifierRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateEntityRecognizerResult createEntityRecognizer(CreateEntityRecognizerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteDocumentClassifierResult deleteDocumentClassifier(DeleteDocumentClassifierRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteEntityRecognizerResult deleteEntityRecognizer(DeleteEntityRecognizerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeDocumentClassificationJobResult describeDocumentClassificationJob(DescribeDocumentClassificationJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeDocumentClassifierResult describeDocumentClassifier(DescribeDocumentClassifierRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeDominantLanguageDetectionJobResult describeDominantLanguageDetectionJob(DescribeDominantLanguageDetectionJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeEntitiesDetectionJobResult describeEntitiesDetectionJob(DescribeEntitiesDetectionJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeEntityRecognizerResult describeEntityRecognizer(DescribeEntityRecognizerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeKeyPhrasesDetectionJobResult describeKeyPhrasesDetectionJob(DescribeKeyPhrasesDetectionJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeSentimentDetectionJobResult describeSentimentDetectionJob(DescribeSentimentDetectionJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeTopicsDetectionJobResult describeTopicsDetectionJob(DescribeTopicsDetectionJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DetectDominantLanguageResult detectDominantLanguage(DetectDominantLanguageRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DetectEntitiesResult detectEntities(DetectEntitiesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DetectKeyPhrasesResult detectKeyPhrases(DetectKeyPhrasesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DetectSentimentResult detectSentiment(DetectSentimentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DetectSyntaxResult detectSyntax(DetectSyntaxRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListDocumentClassificationJobsResult listDocumentClassificationJobs(ListDocumentClassificationJobsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListDocumentClassifiersResult listDocumentClassifiers(ListDocumentClassifiersRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListDominantLanguageDetectionJobsResult listDominantLanguageDetectionJobs(ListDominantLanguageDetectionJobsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListEntitiesDetectionJobsResult listEntitiesDetectionJobs(ListEntitiesDetectionJobsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListEntityRecognizersResult listEntityRecognizers(ListEntityRecognizersRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListKeyPhrasesDetectionJobsResult listKeyPhrasesDetectionJobs(ListKeyPhrasesDetectionJobsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListSentimentDetectionJobsResult listSentimentDetectionJobs(ListSentimentDetectionJobsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTopicsDetectionJobsResult listTopicsDetectionJobs(ListTopicsDetectionJobsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartDocumentClassificationJobResult startDocumentClassificationJob(StartDocumentClassificationJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartDominantLanguageDetectionJobResult startDominantLanguageDetectionJob(StartDominantLanguageDetectionJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartEntitiesDetectionJobResult startEntitiesDetectionJob(StartEntitiesDetectionJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartKeyPhrasesDetectionJobResult startKeyPhrasesDetectionJob(StartKeyPhrasesDetectionJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartSentimentDetectionJobResult startSentimentDetectionJob(StartSentimentDetectionJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartTopicsDetectionJobResult startTopicsDetectionJob(StartTopicsDetectionJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StopDominantLanguageDetectionJobResult stopDominantLanguageDetectionJob(StopDominantLanguageDetectionJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StopEntitiesDetectionJobResult stopEntitiesDetectionJob(StopEntitiesDetectionJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StopKeyPhrasesDetectionJobResult stopKeyPhrasesDetectionJob(StopKeyPhrasesDetectionJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StopSentimentDetectionJobResult stopSentimentDetectionJob(StopSentimentDetectionJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StopTrainingDocumentClassifierResult stopTrainingDocumentClassifier(StopTrainingDocumentClassifierRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StopTrainingEntityRecognizerResult stopTrainingEntityRecognizer(StopTrainingEntityRecognizerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
