/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitosync.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.cognitosync.model.ListDatasetsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class ListDatasetsRequestMarshaller
implements Marshaller<Request<ListDatasetsRequest>, ListDatasetsRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public ListDatasetsRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<ListDatasetsRequest> marshall(ListDatasetsRequest listDatasetsRequest) {
        if (listDatasetsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listDatasetsRequest, "AmazonCognitoSync");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/identitypools/{IdentityPoolId}/identities/{IdentityId}/datasets";
        uriResourcePath = uriResourcePath.replace("{IdentityPoolId}", listDatasetsRequest.getIdentityPoolId() != null ? SdkHttpUtils.urlEncode((String)StringUtils.fromString((String)listDatasetsRequest.getIdentityPoolId()), (boolean)false) : "");
        uriResourcePath = uriResourcePath.replace("{IdentityId}", listDatasetsRequest.getIdentityId() != null ? SdkHttpUtils.urlEncode((String)StringUtils.fromString((String)listDatasetsRequest.getIdentityId()), (boolean)false) : "");
        request.setResourcePath(uriResourcePath);
        if (listDatasetsRequest.getNextToken() != null) {
            request.addParameter("nextToken", StringUtils.fromString((String)listDatasetsRequest.getNextToken()));
        }
        if (listDatasetsRequest.getMaxResults() != null) {
            request.addParameter("maxResults", StringUtils.fromInteger((Integer)listDatasetsRequest.getMaxResults()));
        }
        request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

