/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitosync.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cognitosync.model.ListRecordsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class ListRecordsRequestMarshaller
implements Marshaller<Request<ListRecordsRequest>, ListRecordsRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "application/x-amz-json-1.1";

    public Request<ListRecordsRequest> marshall(ListRecordsRequest listRecordsRequest) {
        String syncSessionToken;
        String maxResults;
        String nextToken;
        String lastSyncCount;
        if (listRecordsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listRecordsRequest, "AmazonCognitoSync");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/identitypools/{IdentityPoolId}/identities/{IdentityId}/datasets/{DatasetName}/records";
        uriResourcePath = uriResourcePath.replace("{IdentityPoolId}", listRecordsRequest.getIdentityPoolId() == null ? "" : StringUtils.fromString((String)listRecordsRequest.getIdentityPoolId()));
        uriResourcePath = uriResourcePath.replace("{IdentityId}", listRecordsRequest.getIdentityId() == null ? "" : StringUtils.fromString((String)listRecordsRequest.getIdentityId()));
        uriResourcePath = uriResourcePath.replace("{DatasetName}", listRecordsRequest.getDatasetName() == null ? "" : StringUtils.fromString((String)listRecordsRequest.getDatasetName()));
        request.setResourcePath(uriResourcePath);
        String string = lastSyncCount = listRecordsRequest.getLastSyncCount() == null ? null : StringUtils.fromLong((Long)listRecordsRequest.getLastSyncCount());
        if (lastSyncCount != null) {
            request.addParameter("lastSyncCount", lastSyncCount);
        }
        String string2 = nextToken = listRecordsRequest.getNextToken() == null ? null : StringUtils.fromString((String)listRecordsRequest.getNextToken());
        if (nextToken != null) {
            request.addParameter("nextToken", nextToken);
        }
        String string3 = maxResults = listRecordsRequest.getMaxResults() == null ? null : StringUtils.fromInteger((Integer)listRecordsRequest.getMaxResults());
        if (maxResults != null) {
            request.addParameter("maxResults", maxResults);
        }
        String string4 = syncSessionToken = listRecordsRequest.getSyncSessionToken() == null ? null : StringUtils.fromString((String)listRecordsRequest.getSyncSessionToken());
        if (syncSessionToken != null) {
            request.addParameter("syncSessionToken", syncSessionToken);
        }
        request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
        }
        return request;
    }
}

