/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitosync.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cognitosync.model.RegisterDeviceRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class RegisterDeviceRequestMarshaller
implements Marshaller<Request<RegisterDeviceRequest>, RegisterDeviceRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "application/x-amz-json-1.1";

    public Request<RegisterDeviceRequest> marshall(RegisterDeviceRequest registerDeviceRequest) {
        if (registerDeviceRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)registerDeviceRequest, "AmazonCognitoSync");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/identitypools/{IdentityPoolId}/identity/{IdentityId}/device";
        uriResourcePath = uriResourcePath.replace("{IdentityPoolId}", registerDeviceRequest.getIdentityPoolId() == null ? "" : StringUtils.fromString((String)registerDeviceRequest.getIdentityPoolId()));
        uriResourcePath = uriResourcePath.replace("{IdentityId}", registerDeviceRequest.getIdentityId() == null ? "" : StringUtils.fromString((String)registerDeviceRequest.getIdentityId()));
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (registerDeviceRequest.getPlatform() != null) {
                jsonWriter.key("Platform").value((Object)registerDeviceRequest.getPlatform());
            }
            if (registerDeviceRequest.getToken() != null) {
                jsonWriter.key("Token").value((Object)registerDeviceRequest.getToken());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
            }
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

