/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitosync.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.cognitosync.model.Dataset;
import com.amazonaws.util.json.JSONWriter;

public class DatasetJsonMarshaller {
    private static DatasetJsonMarshaller instance;

    public void marshall(Dataset dataset, JSONWriter jsonWriter) {
        if (dataset == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            if (dataset.getIdentityId() != null) {
                jsonWriter.key("IdentityId").value((Object)dataset.getIdentityId());
            }
            if (dataset.getDatasetName() != null) {
                jsonWriter.key("DatasetName").value((Object)dataset.getDatasetName());
            }
            if (dataset.getCreationDate() != null) {
                jsonWriter.key("CreationDate").value(dataset.getCreationDate());
            }
            if (dataset.getLastModifiedDate() != null) {
                jsonWriter.key("LastModifiedDate").value(dataset.getLastModifiedDate());
            }
            if (dataset.getLastModifiedBy() != null) {
                jsonWriter.key("LastModifiedBy").value((Object)dataset.getLastModifiedBy());
            }
            if (dataset.getDataStorage() != null) {
                jsonWriter.key("DataStorage").value((Object)dataset.getDataStorage());
            }
            if (dataset.getNumRecords() != null) {
                jsonWriter.key("NumRecords").value((Object)dataset.getNumRecords());
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static DatasetJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new DatasetJsonMarshaller();
        }
        return instance;
    }
}

