/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitosync.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cognitosync.model.DeleteDatasetRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class DeleteDatasetRequestMarshaller
implements Marshaller<Request<DeleteDatasetRequest>, DeleteDatasetRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "application/x-amz-json-1.1";

    public Request<DeleteDatasetRequest> marshall(DeleteDatasetRequest deleteDatasetRequest) {
        if (deleteDatasetRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)deleteDatasetRequest, "AmazonCognitoSync");
        request.setHttpMethod(HttpMethodName.DELETE);
        String uriResourcePath = "/identitypools/{IdentityPoolId}/identities/{IdentityId}/datasets/{DatasetName}";
        uriResourcePath = uriResourcePath.replace("{IdentityPoolId}", deleteDatasetRequest.getIdentityPoolId() == null ? "" : StringUtils.fromString((String)deleteDatasetRequest.getIdentityPoolId()));
        uriResourcePath = uriResourcePath.replace("{IdentityId}", deleteDatasetRequest.getIdentityId() == null ? "" : StringUtils.fromString((String)deleteDatasetRequest.getIdentityId()));
        uriResourcePath = uriResourcePath.replace("{DatasetName}", deleteDatasetRequest.getDatasetName() == null ? "" : StringUtils.fromString((String)deleteDatasetRequest.getDatasetName()));
        request.setResourcePath(uriResourcePath);
        request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
        }
        return request;
    }
}

