/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidp.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.cognitoidp.model.AdminListDevicesRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class AdminListDevicesRequestMarshaller
implements Marshaller<Request<AdminListDevicesRequest>, AdminListDevicesRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public AdminListDevicesRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<AdminListDevicesRequest> marshall(AdminListDevicesRequest adminListDevicesRequest) {
        if (adminListDevicesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)adminListDevicesRequest, "AWSCognitoIdentityProvider");
        request.addHeader("X-Amz-Target", "AWSCognitoIdentityProviderService.AdminListDevices");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (adminListDevicesRequest.getUserPoolId() != null) {
                jsonGenerator.writeFieldName("UserPoolId").writeValue(adminListDevicesRequest.getUserPoolId());
            }
            if (adminListDevicesRequest.getUsername() != null) {
                jsonGenerator.writeFieldName("Username").writeValue(adminListDevicesRequest.getUsername());
            }
            if (adminListDevicesRequest.getLimit() != null) {
                jsonGenerator.writeFieldName("Limit").writeValue(adminListDevicesRequest.getLimit().intValue());
            }
            if (adminListDevicesRequest.getPaginationToken() != null) {
                jsonGenerator.writeFieldName("PaginationToken").writeValue(adminListDevicesRequest.getPaginationToken());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

