/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidp.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.cognitoidp.model.AttributeType;
import com.amazonaws.services.cognitoidp.model.UpdateUserAttributesRequest;
import com.amazonaws.services.cognitoidp.model.transform.AttributeTypeJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;

public class UpdateUserAttributesRequestMarshaller
implements Marshaller<Request<UpdateUserAttributesRequest>, UpdateUserAttributesRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public UpdateUserAttributesRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<UpdateUserAttributesRequest> marshall(UpdateUserAttributesRequest updateUserAttributesRequest) {
        if (updateUserAttributesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)updateUserAttributesRequest, "AWSCognitoIdentityProvider");
        request.addHeader("X-Amz-Target", "AWSCognitoIdentityProviderService.UpdateUserAttributes");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            List<AttributeType> userAttributesList = updateUserAttributesRequest.getUserAttributes();
            if (userAttributesList != null) {
                jsonGenerator.writeFieldName("UserAttributes");
                jsonGenerator.writeStartArray();
                for (AttributeType userAttributesListValue : userAttributesList) {
                    if (userAttributesListValue == null) continue;
                    AttributeTypeJsonMarshaller.getInstance().marshall(userAttributesListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (updateUserAttributesRequest.getAccessToken() != null) {
                jsonGenerator.writeFieldName("AccessToken").writeValue(updateUserAttributesRequest.getAccessToken());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

