/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidp.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.cognitoidp.model.MFAOptionType;
import com.amazonaws.services.cognitoidp.model.SetUserSettingsRequest;
import com.amazonaws.services.cognitoidp.model.transform.MFAOptionTypeJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;

public class SetUserSettingsRequestMarshaller
implements Marshaller<Request<SetUserSettingsRequest>, SetUserSettingsRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public SetUserSettingsRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<SetUserSettingsRequest> marshall(SetUserSettingsRequest setUserSettingsRequest) {
        if (setUserSettingsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)setUserSettingsRequest, "AWSCognitoIdentityProvider");
        request.addHeader("X-Amz-Target", "AWSCognitoIdentityProviderService.SetUserSettings");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            List<MFAOptionType> mFAOptionsList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (setUserSettingsRequest.getAccessToken() != null) {
                jsonGenerator.writeFieldName("AccessToken").writeValue(setUserSettingsRequest.getAccessToken());
            }
            if ((mFAOptionsList = setUserSettingsRequest.getMFAOptions()) != null) {
                jsonGenerator.writeFieldName("MFAOptions");
                jsonGenerator.writeStartArray();
                for (MFAOptionType mFAOptionsListValue : mFAOptionsList) {
                    if (mFAOptionsListValue == null) continue;
                    MFAOptionTypeJsonMarshaller.getInstance().marshall(mFAOptionsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

