/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidp.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.cognitoidp.model.AttributeType;
import com.amazonaws.services.cognitoidp.model.DeviceType;
import com.amazonaws.services.cognitoidp.model.transform.AttributeTypeJsonMarshaller;
import java.util.List;

public class DeviceTypeJsonMarshaller {
    private static DeviceTypeJsonMarshaller instance;

    public void marshall(DeviceType deviceType, StructuredJsonGenerator jsonGenerator) {
        if (deviceType == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<AttributeType> deviceAttributesList;
            jsonGenerator.writeStartObject();
            if (deviceType.getDeviceKey() != null) {
                jsonGenerator.writeFieldName("DeviceKey").writeValue(deviceType.getDeviceKey());
            }
            if ((deviceAttributesList = deviceType.getDeviceAttributes()) != null) {
                jsonGenerator.writeFieldName("DeviceAttributes");
                jsonGenerator.writeStartArray();
                for (AttributeType deviceAttributesListValue : deviceAttributesList) {
                    if (deviceAttributesListValue == null) continue;
                    AttributeTypeJsonMarshaller.getInstance().marshall(deviceAttributesListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (deviceType.getDeviceCreateDate() != null) {
                jsonGenerator.writeFieldName("DeviceCreateDate").writeValue(deviceType.getDeviceCreateDate());
            }
            if (deviceType.getDeviceLastModifiedDate() != null) {
                jsonGenerator.writeFieldName("DeviceLastModifiedDate").writeValue(deviceType.getDeviceLastModifiedDate());
            }
            if (deviceType.getDeviceLastAuthenticatedDate() != null) {
                jsonGenerator.writeFieldName("DeviceLastAuthenticatedDate").writeValue(deviceType.getDeviceLastAuthenticatedDate());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static DeviceTypeJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new DeviceTypeJsonMarshaller();
        }
        return instance;
    }
}

