/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidp.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.cognitoidp.model.CreateUserPoolClientRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;

public class CreateUserPoolClientRequestMarshaller
implements Marshaller<Request<CreateUserPoolClientRequest>, CreateUserPoolClientRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public CreateUserPoolClientRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<CreateUserPoolClientRequest> marshall(CreateUserPoolClientRequest createUserPoolClientRequest) {
        if (createUserPoolClientRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createUserPoolClientRequest, "AWSCognitoIdentityProvider");
        request.addHeader("X-Amz-Target", "AWSCognitoIdentityProviderService.CreateUserPoolClient");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            List<String> list;
            List<String> writeAttributesList;
            List<String> readAttributesList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (createUserPoolClientRequest.getUserPoolId() != null) {
                jsonGenerator.writeFieldName("UserPoolId").writeValue(createUserPoolClientRequest.getUserPoolId());
            }
            if (createUserPoolClientRequest.getClientName() != null) {
                jsonGenerator.writeFieldName("ClientName").writeValue(createUserPoolClientRequest.getClientName());
            }
            if (createUserPoolClientRequest.getGenerateSecret() != null) {
                jsonGenerator.writeFieldName("GenerateSecret").writeValue(createUserPoolClientRequest.getGenerateSecret().booleanValue());
            }
            if (createUserPoolClientRequest.getRefreshTokenValidity() != null) {
                jsonGenerator.writeFieldName("RefreshTokenValidity").writeValue(createUserPoolClientRequest.getRefreshTokenValidity().intValue());
            }
            if ((readAttributesList = createUserPoolClientRequest.getReadAttributes()) != null) {
                jsonGenerator.writeFieldName("ReadAttributes");
                jsonGenerator.writeStartArray();
                for (String string : readAttributesList) {
                    if (string == null) continue;
                    jsonGenerator.writeValue(string);
                }
                jsonGenerator.writeEndArray();
            }
            if ((writeAttributesList = createUserPoolClientRequest.getWriteAttributes()) != null) {
                jsonGenerator.writeFieldName("WriteAttributes");
                jsonGenerator.writeStartArray();
                for (String string : writeAttributesList) {
                    if (string == null) continue;
                    jsonGenerator.writeValue(string);
                }
                jsonGenerator.writeEndArray();
            }
            if ((list = createUserPoolClientRequest.getExplicitAuthFlows()) != null) {
                jsonGenerator.writeFieldName("ExplicitAuthFlows");
                jsonGenerator.writeStartArray();
                for (String explicitAuthFlowsListValue : list) {
                    if (explicitAuthFlowsListValue == null) continue;
                    jsonGenerator.writeValue(explicitAuthFlowsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] byArray = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(byArray));
            request.addHeader("Content-Length", Integer.toString(byArray.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

