/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidp.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.cognitoidp.model.ChallengeNameType;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class RespondToAuthChallengeRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String clientId;
    private String challengeName;
    private String session;
    private Map<String, String> challengeResponses;

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientId() {
        return this.clientId;
    }

    public RespondToAuthChallengeRequest withClientId(String clientId) {
        this.setClientId(clientId);
        return this;
    }

    public void setChallengeName(String challengeName) {
        this.challengeName = challengeName;
    }

    @JsonProperty(value="challengeName")
    public String getChallengeName() {
        return this.challengeName;
    }

    public RespondToAuthChallengeRequest withChallengeName(String challengeName) {
        this.setChallengeName(challengeName);
        return this;
    }

    @JsonIgnore
    public void setChallengeName(ChallengeNameType challengeName) {
        this.withChallengeName(challengeName);
    }

    public RespondToAuthChallengeRequest withChallengeName(ChallengeNameType challengeName) {
        this.challengeName = challengeName.toString();
        return this;
    }

    public void setSession(String session) {
        this.session = session;
    }

    public String getSession() {
        return this.session;
    }

    public RespondToAuthChallengeRequest withSession(String session) {
        this.setSession(session);
        return this;
    }

    public Map<String, String> getChallengeResponses() {
        return this.challengeResponses;
    }

    public void setChallengeResponses(Map<String, String> challengeResponses) {
        this.challengeResponses = challengeResponses;
    }

    public RespondToAuthChallengeRequest withChallengeResponses(Map<String, String> challengeResponses) {
        this.setChallengeResponses(challengeResponses);
        return this;
    }

    public RespondToAuthChallengeRequest addChallengeResponsesEntry(String key, String value) {
        if (null == this.challengeResponses) {
            this.challengeResponses = new HashMap<String, String>();
        }
        if (this.challengeResponses.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.challengeResponses.put(key, value);
        return this;
    }

    public RespondToAuthChallengeRequest clearChallengeResponsesEntries() {
        this.challengeResponses = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getClientId() != null) {
            sb.append("ClientId: ").append(this.getClientId()).append(",");
        }
        if (this.getChallengeName() != null) {
            sb.append("ChallengeName: ").append(this.getChallengeName()).append(",");
        }
        if (this.getSession() != null) {
            sb.append("Session: ").append(this.getSession()).append(",");
        }
        if (this.getChallengeResponses() != null) {
            sb.append("ChallengeResponses: ").append(this.getChallengeResponses());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RespondToAuthChallengeRequest)) {
            return false;
        }
        RespondToAuthChallengeRequest other = (RespondToAuthChallengeRequest)obj;
        if (other.getClientId() == null ^ this.getClientId() == null) {
            return false;
        }
        if (other.getClientId() != null && !other.getClientId().equals(this.getClientId())) {
            return false;
        }
        if (other.getChallengeName() == null ^ this.getChallengeName() == null) {
            return false;
        }
        if (other.getChallengeName() != null && !other.getChallengeName().equals(this.getChallengeName())) {
            return false;
        }
        if (other.getSession() == null ^ this.getSession() == null) {
            return false;
        }
        if (other.getSession() != null && !other.getSession().equals(this.getSession())) {
            return false;
        }
        if (other.getChallengeResponses() == null ^ this.getChallengeResponses() == null) {
            return false;
        }
        return other.getChallengeResponses() == null || other.getChallengeResponses().equals(this.getChallengeResponses());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getClientId() == null ? 0 : this.getClientId().hashCode());
        hashCode = 31 * hashCode + (this.getChallengeName() == null ? 0 : this.getChallengeName().hashCode());
        hashCode = 31 * hashCode + (this.getSession() == null ? 0 : this.getSession().hashCode());
        hashCode = 31 * hashCode + (this.getChallengeResponses() == null ? 0 : this.getChallengeResponses().hashCode());
        return hashCode;
    }

    public RespondToAuthChallengeRequest clone() {
        return (RespondToAuthChallengeRequest)super.clone();
    }
}

