/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidp.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.cognitoidp.model.AdminCreateUserConfigType;
import com.amazonaws.services.cognitoidp.model.AliasAttributeType;
import com.amazonaws.services.cognitoidp.model.DeviceConfigurationType;
import com.amazonaws.services.cognitoidp.model.EmailConfigurationType;
import com.amazonaws.services.cognitoidp.model.LambdaConfigType;
import com.amazonaws.services.cognitoidp.model.SchemaAttributeType;
import com.amazonaws.services.cognitoidp.model.SmsConfigurationType;
import com.amazonaws.services.cognitoidp.model.StatusType;
import com.amazonaws.services.cognitoidp.model.UserPoolMfaType;
import com.amazonaws.services.cognitoidp.model.UserPoolPolicyType;
import com.amazonaws.services.cognitoidp.model.UsernameAttributeType;
import com.amazonaws.services.cognitoidp.model.VerifiedAttributeType;
import com.amazonaws.services.cognitoidp.model.transform.UserPoolTypeMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UserPoolType
implements Serializable,
Cloneable,
StructuredPojo {
    private String id;
    private String name;
    private UserPoolPolicyType policies;
    private LambdaConfigType lambdaConfig;
    private String status;
    private Date lastModifiedDate;
    private Date creationDate;
    private List<SchemaAttributeType> schemaAttributes;
    private List<String> autoVerifiedAttributes;
    private List<String> aliasAttributes;
    private List<String> usernameAttributes;
    private String smsVerificationMessage;
    private String emailVerificationMessage;
    private String emailVerificationSubject;
    private String smsAuthenticationMessage;
    private String mfaConfiguration;
    private DeviceConfigurationType deviceConfiguration;
    private Integer estimatedNumberOfUsers;
    private EmailConfigurationType emailConfiguration;
    private SmsConfigurationType smsConfiguration;
    private Map<String, String> userPoolTags;
    private String smsConfigurationFailure;
    private String emailConfigurationFailure;
    private AdminCreateUserConfigType adminCreateUserConfig;

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public UserPoolType withId(String id) {
        this.setId(id);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public UserPoolType withName(String name) {
        this.setName(name);
        return this;
    }

    public void setPolicies(UserPoolPolicyType policies) {
        this.policies = policies;
    }

    public UserPoolPolicyType getPolicies() {
        return this.policies;
    }

    public UserPoolType withPolicies(UserPoolPolicyType policies) {
        this.setPolicies(policies);
        return this;
    }

    public void setLambdaConfig(LambdaConfigType lambdaConfig) {
        this.lambdaConfig = lambdaConfig;
    }

    public LambdaConfigType getLambdaConfig() {
        return this.lambdaConfig;
    }

    public UserPoolType withLambdaConfig(LambdaConfigType lambdaConfig) {
        this.setLambdaConfig(lambdaConfig);
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public UserPoolType withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public void setStatus(StatusType status) {
        this.withStatus(status);
    }

    public UserPoolType withStatus(StatusType status) {
        this.status = status.toString();
        return this;
    }

    public void setLastModifiedDate(Date lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
    }

    public Date getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public UserPoolType withLastModifiedDate(Date lastModifiedDate) {
        this.setLastModifiedDate(lastModifiedDate);
        return this;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public UserPoolType withCreationDate(Date creationDate) {
        this.setCreationDate(creationDate);
        return this;
    }

    public List<SchemaAttributeType> getSchemaAttributes() {
        return this.schemaAttributes;
    }

    public void setSchemaAttributes(Collection<SchemaAttributeType> schemaAttributes) {
        if (schemaAttributes == null) {
            this.schemaAttributes = null;
            return;
        }
        this.schemaAttributes = new ArrayList<SchemaAttributeType>(schemaAttributes);
    }

    public UserPoolType withSchemaAttributes(SchemaAttributeType ... schemaAttributes) {
        if (this.schemaAttributes == null) {
            this.setSchemaAttributes(new ArrayList<SchemaAttributeType>(schemaAttributes.length));
        }
        for (SchemaAttributeType ele : schemaAttributes) {
            this.schemaAttributes.add(ele);
        }
        return this;
    }

    public UserPoolType withSchemaAttributes(Collection<SchemaAttributeType> schemaAttributes) {
        this.setSchemaAttributes(schemaAttributes);
        return this;
    }

    public List<String> getAutoVerifiedAttributes() {
        return this.autoVerifiedAttributes;
    }

    public void setAutoVerifiedAttributes(Collection<String> autoVerifiedAttributes) {
        if (autoVerifiedAttributes == null) {
            this.autoVerifiedAttributes = null;
            return;
        }
        this.autoVerifiedAttributes = new ArrayList<String>(autoVerifiedAttributes);
    }

    public UserPoolType withAutoVerifiedAttributes(String ... autoVerifiedAttributes) {
        if (this.autoVerifiedAttributes == null) {
            this.setAutoVerifiedAttributes(new ArrayList<String>(autoVerifiedAttributes.length));
        }
        for (String ele : autoVerifiedAttributes) {
            this.autoVerifiedAttributes.add(ele);
        }
        return this;
    }

    public UserPoolType withAutoVerifiedAttributes(Collection<String> autoVerifiedAttributes) {
        this.setAutoVerifiedAttributes(autoVerifiedAttributes);
        return this;
    }

    public UserPoolType withAutoVerifiedAttributes(VerifiedAttributeType ... autoVerifiedAttributes) {
        ArrayList<String> autoVerifiedAttributesCopy = new ArrayList<String>(autoVerifiedAttributes.length);
        for (VerifiedAttributeType value : autoVerifiedAttributes) {
            autoVerifiedAttributesCopy.add(value.toString());
        }
        if (this.getAutoVerifiedAttributes() == null) {
            this.setAutoVerifiedAttributes(autoVerifiedAttributesCopy);
        } else {
            this.getAutoVerifiedAttributes().addAll(autoVerifiedAttributesCopy);
        }
        return this;
    }

    public List<String> getAliasAttributes() {
        return this.aliasAttributes;
    }

    public void setAliasAttributes(Collection<String> aliasAttributes) {
        if (aliasAttributes == null) {
            this.aliasAttributes = null;
            return;
        }
        this.aliasAttributes = new ArrayList<String>(aliasAttributes);
    }

    public UserPoolType withAliasAttributes(String ... aliasAttributes) {
        if (this.aliasAttributes == null) {
            this.setAliasAttributes(new ArrayList<String>(aliasAttributes.length));
        }
        for (String ele : aliasAttributes) {
            this.aliasAttributes.add(ele);
        }
        return this;
    }

    public UserPoolType withAliasAttributes(Collection<String> aliasAttributes) {
        this.setAliasAttributes(aliasAttributes);
        return this;
    }

    public UserPoolType withAliasAttributes(AliasAttributeType ... aliasAttributes) {
        ArrayList<String> aliasAttributesCopy = new ArrayList<String>(aliasAttributes.length);
        for (AliasAttributeType value : aliasAttributes) {
            aliasAttributesCopy.add(value.toString());
        }
        if (this.getAliasAttributes() == null) {
            this.setAliasAttributes(aliasAttributesCopy);
        } else {
            this.getAliasAttributes().addAll(aliasAttributesCopy);
        }
        return this;
    }

    public List<String> getUsernameAttributes() {
        return this.usernameAttributes;
    }

    public void setUsernameAttributes(Collection<String> usernameAttributes) {
        if (usernameAttributes == null) {
            this.usernameAttributes = null;
            return;
        }
        this.usernameAttributes = new ArrayList<String>(usernameAttributes);
    }

    public UserPoolType withUsernameAttributes(String ... usernameAttributes) {
        if (this.usernameAttributes == null) {
            this.setUsernameAttributes(new ArrayList<String>(usernameAttributes.length));
        }
        for (String ele : usernameAttributes) {
            this.usernameAttributes.add(ele);
        }
        return this;
    }

    public UserPoolType withUsernameAttributes(Collection<String> usernameAttributes) {
        this.setUsernameAttributes(usernameAttributes);
        return this;
    }

    public UserPoolType withUsernameAttributes(UsernameAttributeType ... usernameAttributes) {
        ArrayList<String> usernameAttributesCopy = new ArrayList<String>(usernameAttributes.length);
        for (UsernameAttributeType value : usernameAttributes) {
            usernameAttributesCopy.add(value.toString());
        }
        if (this.getUsernameAttributes() == null) {
            this.setUsernameAttributes(usernameAttributesCopy);
        } else {
            this.getUsernameAttributes().addAll(usernameAttributesCopy);
        }
        return this;
    }

    public void setSmsVerificationMessage(String smsVerificationMessage) {
        this.smsVerificationMessage = smsVerificationMessage;
    }

    public String getSmsVerificationMessage() {
        return this.smsVerificationMessage;
    }

    public UserPoolType withSmsVerificationMessage(String smsVerificationMessage) {
        this.setSmsVerificationMessage(smsVerificationMessage);
        return this;
    }

    public void setEmailVerificationMessage(String emailVerificationMessage) {
        this.emailVerificationMessage = emailVerificationMessage;
    }

    public String getEmailVerificationMessage() {
        return this.emailVerificationMessage;
    }

    public UserPoolType withEmailVerificationMessage(String emailVerificationMessage) {
        this.setEmailVerificationMessage(emailVerificationMessage);
        return this;
    }

    public void setEmailVerificationSubject(String emailVerificationSubject) {
        this.emailVerificationSubject = emailVerificationSubject;
    }

    public String getEmailVerificationSubject() {
        return this.emailVerificationSubject;
    }

    public UserPoolType withEmailVerificationSubject(String emailVerificationSubject) {
        this.setEmailVerificationSubject(emailVerificationSubject);
        return this;
    }

    public void setSmsAuthenticationMessage(String smsAuthenticationMessage) {
        this.smsAuthenticationMessage = smsAuthenticationMessage;
    }

    public String getSmsAuthenticationMessage() {
        return this.smsAuthenticationMessage;
    }

    public UserPoolType withSmsAuthenticationMessage(String smsAuthenticationMessage) {
        this.setSmsAuthenticationMessage(smsAuthenticationMessage);
        return this;
    }

    public void setMfaConfiguration(String mfaConfiguration) {
        this.mfaConfiguration = mfaConfiguration;
    }

    public String getMfaConfiguration() {
        return this.mfaConfiguration;
    }

    public UserPoolType withMfaConfiguration(String mfaConfiguration) {
        this.setMfaConfiguration(mfaConfiguration);
        return this;
    }

    public void setMfaConfiguration(UserPoolMfaType mfaConfiguration) {
        this.withMfaConfiguration(mfaConfiguration);
    }

    public UserPoolType withMfaConfiguration(UserPoolMfaType mfaConfiguration) {
        this.mfaConfiguration = mfaConfiguration.toString();
        return this;
    }

    public void setDeviceConfiguration(DeviceConfigurationType deviceConfiguration) {
        this.deviceConfiguration = deviceConfiguration;
    }

    public DeviceConfigurationType getDeviceConfiguration() {
        return this.deviceConfiguration;
    }

    public UserPoolType withDeviceConfiguration(DeviceConfigurationType deviceConfiguration) {
        this.setDeviceConfiguration(deviceConfiguration);
        return this;
    }

    public void setEstimatedNumberOfUsers(Integer estimatedNumberOfUsers) {
        this.estimatedNumberOfUsers = estimatedNumberOfUsers;
    }

    public Integer getEstimatedNumberOfUsers() {
        return this.estimatedNumberOfUsers;
    }

    public UserPoolType withEstimatedNumberOfUsers(Integer estimatedNumberOfUsers) {
        this.setEstimatedNumberOfUsers(estimatedNumberOfUsers);
        return this;
    }

    public void setEmailConfiguration(EmailConfigurationType emailConfiguration) {
        this.emailConfiguration = emailConfiguration;
    }

    public EmailConfigurationType getEmailConfiguration() {
        return this.emailConfiguration;
    }

    public UserPoolType withEmailConfiguration(EmailConfigurationType emailConfiguration) {
        this.setEmailConfiguration(emailConfiguration);
        return this;
    }

    public void setSmsConfiguration(SmsConfigurationType smsConfiguration) {
        this.smsConfiguration = smsConfiguration;
    }

    public SmsConfigurationType getSmsConfiguration() {
        return this.smsConfiguration;
    }

    public UserPoolType withSmsConfiguration(SmsConfigurationType smsConfiguration) {
        this.setSmsConfiguration(smsConfiguration);
        return this;
    }

    public Map<String, String> getUserPoolTags() {
        return this.userPoolTags;
    }

    public void setUserPoolTags(Map<String, String> userPoolTags) {
        this.userPoolTags = userPoolTags;
    }

    public UserPoolType withUserPoolTags(Map<String, String> userPoolTags) {
        this.setUserPoolTags(userPoolTags);
        return this;
    }

    public UserPoolType addUserPoolTagsEntry(String key, String value) {
        if (null == this.userPoolTags) {
            this.userPoolTags = new HashMap<String, String>();
        }
        if (this.userPoolTags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.userPoolTags.put(key, value);
        return this;
    }

    public UserPoolType clearUserPoolTagsEntries() {
        this.userPoolTags = null;
        return this;
    }

    public void setSmsConfigurationFailure(String smsConfigurationFailure) {
        this.smsConfigurationFailure = smsConfigurationFailure;
    }

    public String getSmsConfigurationFailure() {
        return this.smsConfigurationFailure;
    }

    public UserPoolType withSmsConfigurationFailure(String smsConfigurationFailure) {
        this.setSmsConfigurationFailure(smsConfigurationFailure);
        return this;
    }

    public void setEmailConfigurationFailure(String emailConfigurationFailure) {
        this.emailConfigurationFailure = emailConfigurationFailure;
    }

    public String getEmailConfigurationFailure() {
        return this.emailConfigurationFailure;
    }

    public UserPoolType withEmailConfigurationFailure(String emailConfigurationFailure) {
        this.setEmailConfigurationFailure(emailConfigurationFailure);
        return this;
    }

    public void setAdminCreateUserConfig(AdminCreateUserConfigType adminCreateUserConfig) {
        this.adminCreateUserConfig = adminCreateUserConfig;
    }

    public AdminCreateUserConfigType getAdminCreateUserConfig() {
        return this.adminCreateUserConfig;
    }

    public UserPoolType withAdminCreateUserConfig(AdminCreateUserConfigType adminCreateUserConfig) {
        this.setAdminCreateUserConfig(adminCreateUserConfig);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getId() != null) {
            sb.append("Id: ").append(this.getId()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getPolicies() != null) {
            sb.append("Policies: ").append(this.getPolicies()).append(",");
        }
        if (this.getLambdaConfig() != null) {
            sb.append("LambdaConfig: ").append(this.getLambdaConfig()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getLastModifiedDate() != null) {
            sb.append("LastModifiedDate: ").append(this.getLastModifiedDate()).append(",");
        }
        if (this.getCreationDate() != null) {
            sb.append("CreationDate: ").append(this.getCreationDate()).append(",");
        }
        if (this.getSchemaAttributes() != null) {
            sb.append("SchemaAttributes: ").append(this.getSchemaAttributes()).append(",");
        }
        if (this.getAutoVerifiedAttributes() != null) {
            sb.append("AutoVerifiedAttributes: ").append(this.getAutoVerifiedAttributes()).append(",");
        }
        if (this.getAliasAttributes() != null) {
            sb.append("AliasAttributes: ").append(this.getAliasAttributes()).append(",");
        }
        if (this.getUsernameAttributes() != null) {
            sb.append("UsernameAttributes: ").append(this.getUsernameAttributes()).append(",");
        }
        if (this.getSmsVerificationMessage() != null) {
            sb.append("SmsVerificationMessage: ").append(this.getSmsVerificationMessage()).append(",");
        }
        if (this.getEmailVerificationMessage() != null) {
            sb.append("EmailVerificationMessage: ").append(this.getEmailVerificationMessage()).append(",");
        }
        if (this.getEmailVerificationSubject() != null) {
            sb.append("EmailVerificationSubject: ").append(this.getEmailVerificationSubject()).append(",");
        }
        if (this.getSmsAuthenticationMessage() != null) {
            sb.append("SmsAuthenticationMessage: ").append(this.getSmsAuthenticationMessage()).append(",");
        }
        if (this.getMfaConfiguration() != null) {
            sb.append("MfaConfiguration: ").append(this.getMfaConfiguration()).append(",");
        }
        if (this.getDeviceConfiguration() != null) {
            sb.append("DeviceConfiguration: ").append(this.getDeviceConfiguration()).append(",");
        }
        if (this.getEstimatedNumberOfUsers() != null) {
            sb.append("EstimatedNumberOfUsers: ").append(this.getEstimatedNumberOfUsers()).append(",");
        }
        if (this.getEmailConfiguration() != null) {
            sb.append("EmailConfiguration: ").append(this.getEmailConfiguration()).append(",");
        }
        if (this.getSmsConfiguration() != null) {
            sb.append("SmsConfiguration: ").append(this.getSmsConfiguration()).append(",");
        }
        if (this.getUserPoolTags() != null) {
            sb.append("UserPoolTags: ").append(this.getUserPoolTags()).append(",");
        }
        if (this.getSmsConfigurationFailure() != null) {
            sb.append("SmsConfigurationFailure: ").append(this.getSmsConfigurationFailure()).append(",");
        }
        if (this.getEmailConfigurationFailure() != null) {
            sb.append("EmailConfigurationFailure: ").append(this.getEmailConfigurationFailure()).append(",");
        }
        if (this.getAdminCreateUserConfig() != null) {
            sb.append("AdminCreateUserConfig: ").append(this.getAdminCreateUserConfig());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserPoolType)) {
            return false;
        }
        UserPoolType other = (UserPoolType)obj;
        if (other.getId() == null ^ this.getId() == null) {
            return false;
        }
        if (other.getId() != null && !other.getId().equals(this.getId())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getPolicies() == null ^ this.getPolicies() == null) {
            return false;
        }
        if (other.getPolicies() != null && !other.getPolicies().equals(this.getPolicies())) {
            return false;
        }
        if (other.getLambdaConfig() == null ^ this.getLambdaConfig() == null) {
            return false;
        }
        if (other.getLambdaConfig() != null && !other.getLambdaConfig().equals(this.getLambdaConfig())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getLastModifiedDate() == null ^ this.getLastModifiedDate() == null) {
            return false;
        }
        if (other.getLastModifiedDate() != null && !other.getLastModifiedDate().equals(this.getLastModifiedDate())) {
            return false;
        }
        if (other.getCreationDate() == null ^ this.getCreationDate() == null) {
            return false;
        }
        if (other.getCreationDate() != null && !other.getCreationDate().equals(this.getCreationDate())) {
            return false;
        }
        if (other.getSchemaAttributes() == null ^ this.getSchemaAttributes() == null) {
            return false;
        }
        if (other.getSchemaAttributes() != null && !other.getSchemaAttributes().equals(this.getSchemaAttributes())) {
            return false;
        }
        if (other.getAutoVerifiedAttributes() == null ^ this.getAutoVerifiedAttributes() == null) {
            return false;
        }
        if (other.getAutoVerifiedAttributes() != null && !other.getAutoVerifiedAttributes().equals(this.getAutoVerifiedAttributes())) {
            return false;
        }
        if (other.getAliasAttributes() == null ^ this.getAliasAttributes() == null) {
            return false;
        }
        if (other.getAliasAttributes() != null && !other.getAliasAttributes().equals(this.getAliasAttributes())) {
            return false;
        }
        if (other.getUsernameAttributes() == null ^ this.getUsernameAttributes() == null) {
            return false;
        }
        if (other.getUsernameAttributes() != null && !other.getUsernameAttributes().equals(this.getUsernameAttributes())) {
            return false;
        }
        if (other.getSmsVerificationMessage() == null ^ this.getSmsVerificationMessage() == null) {
            return false;
        }
        if (other.getSmsVerificationMessage() != null && !other.getSmsVerificationMessage().equals(this.getSmsVerificationMessage())) {
            return false;
        }
        if (other.getEmailVerificationMessage() == null ^ this.getEmailVerificationMessage() == null) {
            return false;
        }
        if (other.getEmailVerificationMessage() != null && !other.getEmailVerificationMessage().equals(this.getEmailVerificationMessage())) {
            return false;
        }
        if (other.getEmailVerificationSubject() == null ^ this.getEmailVerificationSubject() == null) {
            return false;
        }
        if (other.getEmailVerificationSubject() != null && !other.getEmailVerificationSubject().equals(this.getEmailVerificationSubject())) {
            return false;
        }
        if (other.getSmsAuthenticationMessage() == null ^ this.getSmsAuthenticationMessage() == null) {
            return false;
        }
        if (other.getSmsAuthenticationMessage() != null && !other.getSmsAuthenticationMessage().equals(this.getSmsAuthenticationMessage())) {
            return false;
        }
        if (other.getMfaConfiguration() == null ^ this.getMfaConfiguration() == null) {
            return false;
        }
        if (other.getMfaConfiguration() != null && !other.getMfaConfiguration().equals(this.getMfaConfiguration())) {
            return false;
        }
        if (other.getDeviceConfiguration() == null ^ this.getDeviceConfiguration() == null) {
            return false;
        }
        if (other.getDeviceConfiguration() != null && !other.getDeviceConfiguration().equals(this.getDeviceConfiguration())) {
            return false;
        }
        if (other.getEstimatedNumberOfUsers() == null ^ this.getEstimatedNumberOfUsers() == null) {
            return false;
        }
        if (other.getEstimatedNumberOfUsers() != null && !other.getEstimatedNumberOfUsers().equals(this.getEstimatedNumberOfUsers())) {
            return false;
        }
        if (other.getEmailConfiguration() == null ^ this.getEmailConfiguration() == null) {
            return false;
        }
        if (other.getEmailConfiguration() != null && !other.getEmailConfiguration().equals(this.getEmailConfiguration())) {
            return false;
        }
        if (other.getSmsConfiguration() == null ^ this.getSmsConfiguration() == null) {
            return false;
        }
        if (other.getSmsConfiguration() != null && !other.getSmsConfiguration().equals(this.getSmsConfiguration())) {
            return false;
        }
        if (other.getUserPoolTags() == null ^ this.getUserPoolTags() == null) {
            return false;
        }
        if (other.getUserPoolTags() != null && !other.getUserPoolTags().equals(this.getUserPoolTags())) {
            return false;
        }
        if (other.getSmsConfigurationFailure() == null ^ this.getSmsConfigurationFailure() == null) {
            return false;
        }
        if (other.getSmsConfigurationFailure() != null && !other.getSmsConfigurationFailure().equals(this.getSmsConfigurationFailure())) {
            return false;
        }
        if (other.getEmailConfigurationFailure() == null ^ this.getEmailConfigurationFailure() == null) {
            return false;
        }
        if (other.getEmailConfigurationFailure() != null && !other.getEmailConfigurationFailure().equals(this.getEmailConfigurationFailure())) {
            return false;
        }
        if (other.getAdminCreateUserConfig() == null ^ this.getAdminCreateUserConfig() == null) {
            return false;
        }
        return other.getAdminCreateUserConfig() == null || other.getAdminCreateUserConfig().equals(this.getAdminCreateUserConfig());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getId() == null ? 0 : this.getId().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getPolicies() == null ? 0 : this.getPolicies().hashCode());
        hashCode = 31 * hashCode + (this.getLambdaConfig() == null ? 0 : this.getLambdaConfig().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getLastModifiedDate() == null ? 0 : this.getLastModifiedDate().hashCode());
        hashCode = 31 * hashCode + (this.getCreationDate() == null ? 0 : this.getCreationDate().hashCode());
        hashCode = 31 * hashCode + (this.getSchemaAttributes() == null ? 0 : this.getSchemaAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getAutoVerifiedAttributes() == null ? 0 : this.getAutoVerifiedAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getAliasAttributes() == null ? 0 : this.getAliasAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getUsernameAttributes() == null ? 0 : this.getUsernameAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getSmsVerificationMessage() == null ? 0 : this.getSmsVerificationMessage().hashCode());
        hashCode = 31 * hashCode + (this.getEmailVerificationMessage() == null ? 0 : this.getEmailVerificationMessage().hashCode());
        hashCode = 31 * hashCode + (this.getEmailVerificationSubject() == null ? 0 : this.getEmailVerificationSubject().hashCode());
        hashCode = 31 * hashCode + (this.getSmsAuthenticationMessage() == null ? 0 : this.getSmsAuthenticationMessage().hashCode());
        hashCode = 31 * hashCode + (this.getMfaConfiguration() == null ? 0 : this.getMfaConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getDeviceConfiguration() == null ? 0 : this.getDeviceConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getEstimatedNumberOfUsers() == null ? 0 : this.getEstimatedNumberOfUsers().hashCode());
        hashCode = 31 * hashCode + (this.getEmailConfiguration() == null ? 0 : this.getEmailConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getSmsConfiguration() == null ? 0 : this.getSmsConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getUserPoolTags() == null ? 0 : this.getUserPoolTags().hashCode());
        hashCode = 31 * hashCode + (this.getSmsConfigurationFailure() == null ? 0 : this.getSmsConfigurationFailure().hashCode());
        hashCode = 31 * hashCode + (this.getEmailConfigurationFailure() == null ? 0 : this.getEmailConfigurationFailure().hashCode());
        hashCode = 31 * hashCode + (this.getAdminCreateUserConfig() == null ? 0 : this.getAdminCreateUserConfig().hashCode());
        return hashCode;
    }

    public UserPoolType clone() {
        try {
            return (UserPoolType)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        UserPoolTypeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

