/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidp.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.cognitoidp.model.AttributeType;
import com.amazonaws.services.cognitoidp.model.SignUpRequest;
import com.amazonaws.services.cognitoidp.model.transform.AttributeTypeJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;

public class SignUpRequestMarshaller
implements Marshaller<Request<SignUpRequest>, SignUpRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public SignUpRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<SignUpRequest> marshall(SignUpRequest signUpRequest) {
        if (signUpRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)signUpRequest, "AWSCognitoIdentityProvider");
        request.addHeader("X-Amz-Target", "AWSCognitoIdentityProviderService.SignUp");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            List<AttributeType> validationDataList;
            List<AttributeType> userAttributesList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (signUpRequest.getClientId() != null) {
                jsonGenerator.writeFieldName("ClientId").writeValue(signUpRequest.getClientId());
            }
            if (signUpRequest.getSecretHash() != null) {
                jsonGenerator.writeFieldName("SecretHash").writeValue(signUpRequest.getSecretHash());
            }
            if (signUpRequest.getUsername() != null) {
                jsonGenerator.writeFieldName("Username").writeValue(signUpRequest.getUsername());
            }
            if (signUpRequest.getPassword() != null) {
                jsonGenerator.writeFieldName("Password").writeValue(signUpRequest.getPassword());
            }
            if ((userAttributesList = signUpRequest.getUserAttributes()) != null) {
                jsonGenerator.writeFieldName("UserAttributes");
                jsonGenerator.writeStartArray();
                for (AttributeType userAttributesListValue : userAttributesList) {
                    if (userAttributesListValue == null) continue;
                    AttributeTypeJsonMarshaller.getInstance().marshall(userAttributesListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if ((validationDataList = signUpRequest.getValidationData()) != null) {
                jsonGenerator.writeFieldName("ValidationData");
                jsonGenerator.writeStartArray();
                for (AttributeType validationDataListValue : validationDataList) {
                    if (validationDataListValue == null) continue;
                    AttributeTypeJsonMarshaller.getInstance().marshall(validationDataListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

