/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidp.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cognitoidp.model.ConfirmForgotPasswordRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonProtocolFactory;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class ConfirmForgotPasswordRequestMarshaller
implements Marshaller<Request<ConfirmForgotPasswordRequest>, ConfirmForgotPasswordRequest> {
    public Request<ConfirmForgotPasswordRequest> marshall(ConfirmForgotPasswordRequest confirmForgotPasswordRequest) {
        if (confirmForgotPasswordRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)confirmForgotPasswordRequest, "AWSCognitoIdentityProvider");
        request.addHeader("X-Amz-Target", "AWSCognitoIdentityProviderService.ConfirmForgotPassword");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = SdkJsonProtocolFactory.createWriter((boolean)false, (String)"1.1");
            jsonGenerator.writeStartObject();
            if (confirmForgotPasswordRequest.getClientId() != null) {
                jsonGenerator.writeFieldName("ClientId").writeValue(confirmForgotPasswordRequest.getClientId());
            }
            if (confirmForgotPasswordRequest.getSecretHash() != null) {
                jsonGenerator.writeFieldName("SecretHash").writeValue(confirmForgotPasswordRequest.getSecretHash());
            }
            if (confirmForgotPasswordRequest.getUsername() != null) {
                jsonGenerator.writeFieldName("Username").writeValue(confirmForgotPasswordRequest.getUsername());
            }
            if (confirmForgotPasswordRequest.getConfirmationCode() != null) {
                jsonGenerator.writeFieldName("ConfirmationCode").writeValue(confirmForgotPasswordRequest.getConfirmationCode());
            }
            if (confirmForgotPasswordRequest.getPassword() != null) {
                jsonGenerator.writeFieldName("Password").writeValue(confirmForgotPasswordRequest.getPassword());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

