/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentity.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.cognitoidentity.model.Credentials;
import java.util.Date;

@SdkInternalApi
public class CredentialsMarshaller {
    private static final MarshallingInfo<String> ACCESSKEYID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AccessKeyId").build();
    private static final MarshallingInfo<String> SECRETKEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SecretKey").build();
    private static final MarshallingInfo<String> SESSIONTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SessionToken").build();
    private static final MarshallingInfo<Date> EXPIRATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Expiration").timestampFormat("unixTimestamp").build();
    private static final CredentialsMarshaller instance = new CredentialsMarshaller();

    public static CredentialsMarshaller getInstance() {
        return instance;
    }

    public void marshall(Credentials credentials, ProtocolMarshaller protocolMarshaller) {
        if (credentials == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)credentials.getAccessKeyId(), ACCESSKEYID_BINDING);
            protocolMarshaller.marshall((Object)credentials.getSecretKey(), SECRETKEY_BINDING);
            protocolMarshaller.marshall((Object)credentials.getSessionToken(), SESSIONTOKEN_BINDING);
            protocolMarshaller.marshall((Object)credentials.getExpiration(), EXPIRATION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

