/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codestarnotifications;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.codestarnotifications.AWSCodeStarNotificationsAsync;
import com.amazonaws.services.codestarnotifications.AWSCodeStarNotificationsAsyncClientBuilder;
import com.amazonaws.services.codestarnotifications.AWSCodeStarNotificationsClient;
import com.amazonaws.services.codestarnotifications.model.CreateNotificationRuleRequest;
import com.amazonaws.services.codestarnotifications.model.CreateNotificationRuleResult;
import com.amazonaws.services.codestarnotifications.model.DeleteNotificationRuleRequest;
import com.amazonaws.services.codestarnotifications.model.DeleteNotificationRuleResult;
import com.amazonaws.services.codestarnotifications.model.DeleteTargetRequest;
import com.amazonaws.services.codestarnotifications.model.DeleteTargetResult;
import com.amazonaws.services.codestarnotifications.model.DescribeNotificationRuleRequest;
import com.amazonaws.services.codestarnotifications.model.DescribeNotificationRuleResult;
import com.amazonaws.services.codestarnotifications.model.ListEventTypesRequest;
import com.amazonaws.services.codestarnotifications.model.ListEventTypesResult;
import com.amazonaws.services.codestarnotifications.model.ListNotificationRulesRequest;
import com.amazonaws.services.codestarnotifications.model.ListNotificationRulesResult;
import com.amazonaws.services.codestarnotifications.model.ListTagsForResourceRequest;
import com.amazonaws.services.codestarnotifications.model.ListTagsForResourceResult;
import com.amazonaws.services.codestarnotifications.model.ListTargetsRequest;
import com.amazonaws.services.codestarnotifications.model.ListTargetsResult;
import com.amazonaws.services.codestarnotifications.model.SubscribeRequest;
import com.amazonaws.services.codestarnotifications.model.SubscribeResult;
import com.amazonaws.services.codestarnotifications.model.TagResourceRequest;
import com.amazonaws.services.codestarnotifications.model.TagResourceResult;
import com.amazonaws.services.codestarnotifications.model.UnsubscribeRequest;
import com.amazonaws.services.codestarnotifications.model.UnsubscribeResult;
import com.amazonaws.services.codestarnotifications.model.UntagResourceRequest;
import com.amazonaws.services.codestarnotifications.model.UntagResourceResult;
import com.amazonaws.services.codestarnotifications.model.UpdateNotificationRuleRequest;
import com.amazonaws.services.codestarnotifications.model.UpdateNotificationRuleResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSCodeStarNotificationsAsyncClient
extends AWSCodeStarNotificationsClient
implements AWSCodeStarNotificationsAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSCodeStarNotificationsAsyncClientBuilder asyncBuilder() {
        return AWSCodeStarNotificationsAsyncClientBuilder.standard();
    }

    AWSCodeStarNotificationsAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AWSCodeStarNotificationsAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CreateNotificationRuleResult> createNotificationRuleAsync(CreateNotificationRuleRequest request) {
        return this.createNotificationRuleAsync(request, null);
    }

    @Override
    public Future<CreateNotificationRuleResult> createNotificationRuleAsync(CreateNotificationRuleRequest request, final AsyncHandler<CreateNotificationRuleRequest, CreateNotificationRuleResult> asyncHandler) {
        final CreateNotificationRuleRequest finalRequest = (CreateNotificationRuleRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateNotificationRuleResult>(){

            @Override
            public CreateNotificationRuleResult call() throws Exception {
                CreateNotificationRuleResult result = null;
                try {
                    result = AWSCodeStarNotificationsAsyncClient.this.executeCreateNotificationRule(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteNotificationRuleResult> deleteNotificationRuleAsync(DeleteNotificationRuleRequest request) {
        return this.deleteNotificationRuleAsync(request, null);
    }

    @Override
    public Future<DeleteNotificationRuleResult> deleteNotificationRuleAsync(DeleteNotificationRuleRequest request, final AsyncHandler<DeleteNotificationRuleRequest, DeleteNotificationRuleResult> asyncHandler) {
        final DeleteNotificationRuleRequest finalRequest = (DeleteNotificationRuleRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteNotificationRuleResult>(){

            @Override
            public DeleteNotificationRuleResult call() throws Exception {
                DeleteNotificationRuleResult result = null;
                try {
                    result = AWSCodeStarNotificationsAsyncClient.this.executeDeleteNotificationRule(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteTargetResult> deleteTargetAsync(DeleteTargetRequest request) {
        return this.deleteTargetAsync(request, null);
    }

    @Override
    public Future<DeleteTargetResult> deleteTargetAsync(DeleteTargetRequest request, final AsyncHandler<DeleteTargetRequest, DeleteTargetResult> asyncHandler) {
        final DeleteTargetRequest finalRequest = (DeleteTargetRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteTargetResult>(){

            @Override
            public DeleteTargetResult call() throws Exception {
                DeleteTargetResult result = null;
                try {
                    result = AWSCodeStarNotificationsAsyncClient.this.executeDeleteTarget(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeNotificationRuleResult> describeNotificationRuleAsync(DescribeNotificationRuleRequest request) {
        return this.describeNotificationRuleAsync(request, null);
    }

    @Override
    public Future<DescribeNotificationRuleResult> describeNotificationRuleAsync(DescribeNotificationRuleRequest request, final AsyncHandler<DescribeNotificationRuleRequest, DescribeNotificationRuleResult> asyncHandler) {
        final DescribeNotificationRuleRequest finalRequest = (DescribeNotificationRuleRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeNotificationRuleResult>(){

            @Override
            public DescribeNotificationRuleResult call() throws Exception {
                DescribeNotificationRuleResult result = null;
                try {
                    result = AWSCodeStarNotificationsAsyncClient.this.executeDescribeNotificationRule(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListEventTypesResult> listEventTypesAsync(ListEventTypesRequest request) {
        return this.listEventTypesAsync(request, null);
    }

    @Override
    public Future<ListEventTypesResult> listEventTypesAsync(ListEventTypesRequest request, final AsyncHandler<ListEventTypesRequest, ListEventTypesResult> asyncHandler) {
        final ListEventTypesRequest finalRequest = (ListEventTypesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListEventTypesResult>(){

            @Override
            public ListEventTypesResult call() throws Exception {
                ListEventTypesResult result = null;
                try {
                    result = AWSCodeStarNotificationsAsyncClient.this.executeListEventTypes(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListNotificationRulesResult> listNotificationRulesAsync(ListNotificationRulesRequest request) {
        return this.listNotificationRulesAsync(request, null);
    }

    @Override
    public Future<ListNotificationRulesResult> listNotificationRulesAsync(ListNotificationRulesRequest request, final AsyncHandler<ListNotificationRulesRequest, ListNotificationRulesResult> asyncHandler) {
        final ListNotificationRulesRequest finalRequest = (ListNotificationRulesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListNotificationRulesResult>(){

            @Override
            public ListNotificationRulesResult call() throws Exception {
                ListNotificationRulesResult result = null;
                try {
                    result = AWSCodeStarNotificationsAsyncClient.this.executeListNotificationRules(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AWSCodeStarNotificationsAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTargetsResult> listTargetsAsync(ListTargetsRequest request) {
        return this.listTargetsAsync(request, null);
    }

    @Override
    public Future<ListTargetsResult> listTargetsAsync(ListTargetsRequest request, final AsyncHandler<ListTargetsRequest, ListTargetsResult> asyncHandler) {
        final ListTargetsRequest finalRequest = (ListTargetsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTargetsResult>(){

            @Override
            public ListTargetsResult call() throws Exception {
                ListTargetsResult result = null;
                try {
                    result = AWSCodeStarNotificationsAsyncClient.this.executeListTargets(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SubscribeResult> subscribeAsync(SubscribeRequest request) {
        return this.subscribeAsync(request, null);
    }

    @Override
    public Future<SubscribeResult> subscribeAsync(SubscribeRequest request, final AsyncHandler<SubscribeRequest, SubscribeResult> asyncHandler) {
        final SubscribeRequest finalRequest = (SubscribeRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<SubscribeResult>(){

            @Override
            public SubscribeResult call() throws Exception {
                SubscribeResult result = null;
                try {
                    result = AWSCodeStarNotificationsAsyncClient.this.executeSubscribe(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AWSCodeStarNotificationsAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UnsubscribeResult> unsubscribeAsync(UnsubscribeRequest request) {
        return this.unsubscribeAsync(request, null);
    }

    @Override
    public Future<UnsubscribeResult> unsubscribeAsync(UnsubscribeRequest request, final AsyncHandler<UnsubscribeRequest, UnsubscribeResult> asyncHandler) {
        final UnsubscribeRequest finalRequest = (UnsubscribeRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UnsubscribeResult>(){

            @Override
            public UnsubscribeResult call() throws Exception {
                UnsubscribeResult result = null;
                try {
                    result = AWSCodeStarNotificationsAsyncClient.this.executeUnsubscribe(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AWSCodeStarNotificationsAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateNotificationRuleResult> updateNotificationRuleAsync(UpdateNotificationRuleRequest request) {
        return this.updateNotificationRuleAsync(request, null);
    }

    @Override
    public Future<UpdateNotificationRuleResult> updateNotificationRuleAsync(UpdateNotificationRuleRequest request, final AsyncHandler<UpdateNotificationRuleRequest, UpdateNotificationRuleResult> asyncHandler) {
        final UpdateNotificationRuleRequest finalRequest = (UpdateNotificationRuleRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateNotificationRuleResult>(){

            @Override
            public UpdateNotificationRuleResult call() throws Exception {
                UpdateNotificationRuleResult result = null;
                try {
                    result = AWSCodeStarNotificationsAsyncClient.this.executeUpdateNotificationRule(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

