/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.codestarconnections.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/GetSyncBlockerSummary"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class GetSyncBlockerSummaryRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * The sync type for the sync blocker summary.
     * </p>
     */
    private String syncType;
    /**
     * <p>
     * The name of the Amazon Web Services resource currently blocked from automatically being synced from a Git
     * repository.
     * </p>
     */
    private String resourceName;

    /**
     * <p>
     * The sync type for the sync blocker summary.
     * </p>
     * 
     * @param syncType
     *        The sync type for the sync blocker summary.
     * @see SyncConfigurationType
     */

    public void setSyncType(String syncType) {
        this.syncType = syncType;
    }

    /**
     * <p>
     * The sync type for the sync blocker summary.
     * </p>
     * 
     * @return The sync type for the sync blocker summary.
     * @see SyncConfigurationType
     */

    public String getSyncType() {
        return this.syncType;
    }

    /**
     * <p>
     * The sync type for the sync blocker summary.
     * </p>
     * 
     * @param syncType
     *        The sync type for the sync blocker summary.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see SyncConfigurationType
     */

    public GetSyncBlockerSummaryRequest withSyncType(String syncType) {
        setSyncType(syncType);
        return this;
    }

    /**
     * <p>
     * The sync type for the sync blocker summary.
     * </p>
     * 
     * @param syncType
     *        The sync type for the sync blocker summary.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see SyncConfigurationType
     */

    public GetSyncBlockerSummaryRequest withSyncType(SyncConfigurationType syncType) {
        this.syncType = syncType.toString();
        return this;
    }

    /**
     * <p>
     * The name of the Amazon Web Services resource currently blocked from automatically being synced from a Git
     * repository.
     * </p>
     * 
     * @param resourceName
     *        The name of the Amazon Web Services resource currently blocked from automatically being synced from a Git
     *        repository.
     */

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    /**
     * <p>
     * The name of the Amazon Web Services resource currently blocked from automatically being synced from a Git
     * repository.
     * </p>
     * 
     * @return The name of the Amazon Web Services resource currently blocked from automatically being synced from a Git
     *         repository.
     */

    public String getResourceName() {
        return this.resourceName;
    }

    /**
     * <p>
     * The name of the Amazon Web Services resource currently blocked from automatically being synced from a Git
     * repository.
     * </p>
     * 
     * @param resourceName
     *        The name of the Amazon Web Services resource currently blocked from automatically being synced from a Git
     *        repository.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetSyncBlockerSummaryRequest withResourceName(String resourceName) {
        setResourceName(resourceName);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getSyncType() != null)
            sb.append("SyncType: ").append(getSyncType()).append(",");
        if (getResourceName() != null)
            sb.append("ResourceName: ").append(getResourceName());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof GetSyncBlockerSummaryRequest == false)
            return false;
        GetSyncBlockerSummaryRequest other = (GetSyncBlockerSummaryRequest) obj;
        if (other.getSyncType() == null ^ this.getSyncType() == null)
            return false;
        if (other.getSyncType() != null && other.getSyncType().equals(this.getSyncType()) == false)
            return false;
        if (other.getResourceName() == null ^ this.getResourceName() == null)
            return false;
        if (other.getResourceName() != null && other.getResourceName().equals(this.getResourceName()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getSyncType() == null) ? 0 : getSyncType().hashCode());
        hashCode = prime * hashCode + ((getResourceName() == null) ? 0 : getResourceName().hashCode());
        return hashCode;
    }

    @Override
    public GetSyncBlockerSummaryRequest clone() {
        return (GetSyncBlockerSummaryRequest) super.clone();
    }

}
