/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codepipeline.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.codepipeline.model.transform.GitTagFilterCriteriaMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GitTagFilterCriteria
implements Serializable,
Cloneable,
StructuredPojo {
    private List<String> includes;
    private List<String> excludes;

    public List<String> getIncludes() {
        return this.includes;
    }

    public void setIncludes(Collection<String> includes) {
        if (includes == null) {
            this.includes = null;
            return;
        }
        this.includes = new ArrayList<String>(includes);
    }

    public GitTagFilterCriteria withIncludes(String ... includes) {
        if (this.includes == null) {
            this.setIncludes(new ArrayList<String>(includes.length));
        }
        for (String ele : includes) {
            this.includes.add(ele);
        }
        return this;
    }

    public GitTagFilterCriteria withIncludes(Collection<String> includes) {
        this.setIncludes(includes);
        return this;
    }

    public List<String> getExcludes() {
        return this.excludes;
    }

    public void setExcludes(Collection<String> excludes) {
        if (excludes == null) {
            this.excludes = null;
            return;
        }
        this.excludes = new ArrayList<String>(excludes);
    }

    public GitTagFilterCriteria withExcludes(String ... excludes) {
        if (this.excludes == null) {
            this.setExcludes(new ArrayList<String>(excludes.length));
        }
        for (String ele : excludes) {
            this.excludes.add(ele);
        }
        return this;
    }

    public GitTagFilterCriteria withExcludes(Collection<String> excludes) {
        this.setExcludes(excludes);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getIncludes() != null) {
            sb.append("Includes: ").append(this.getIncludes()).append(",");
        }
        if (this.getExcludes() != null) {
            sb.append("Excludes: ").append(this.getExcludes());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GitTagFilterCriteria)) {
            return false;
        }
        GitTagFilterCriteria other = (GitTagFilterCriteria)obj;
        if (other.getIncludes() == null ^ this.getIncludes() == null) {
            return false;
        }
        if (other.getIncludes() != null && !other.getIncludes().equals(this.getIncludes())) {
            return false;
        }
        if (other.getExcludes() == null ^ this.getExcludes() == null) {
            return false;
        }
        return other.getExcludes() == null || other.getExcludes().equals(this.getExcludes());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getIncludes() == null ? 0 : this.getIncludes().hashCode());
        hashCode = 31 * hashCode + (this.getExcludes() == null ? 0 : this.getExcludes().hashCode());
        return hashCode;
    }

    public GitTagFilterCriteria clone() {
        try {
            return (GitTagFilterCriteria)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        GitTagFilterCriteriaMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

