/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codepipeline.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.codepipeline.model.ActionDeclaration;
import com.amazonaws.services.codepipeline.model.BlockerDeclaration;
import com.amazonaws.services.codepipeline.model.FailureConditions;
import com.amazonaws.services.codepipeline.model.transform.StageDeclarationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class StageDeclaration
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private List<BlockerDeclaration> blockers;
    private List<ActionDeclaration> actions;
    private FailureConditions onFailure;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public StageDeclaration withName(String name) {
        this.setName(name);
        return this;
    }

    public List<BlockerDeclaration> getBlockers() {
        return this.blockers;
    }

    public void setBlockers(Collection<BlockerDeclaration> blockers) {
        if (blockers == null) {
            this.blockers = null;
            return;
        }
        this.blockers = new ArrayList<BlockerDeclaration>(blockers);
    }

    public StageDeclaration withBlockers(BlockerDeclaration ... blockers) {
        if (this.blockers == null) {
            this.setBlockers(new ArrayList<BlockerDeclaration>(blockers.length));
        }
        for (BlockerDeclaration ele : blockers) {
            this.blockers.add(ele);
        }
        return this;
    }

    public StageDeclaration withBlockers(Collection<BlockerDeclaration> blockers) {
        this.setBlockers(blockers);
        return this;
    }

    public List<ActionDeclaration> getActions() {
        return this.actions;
    }

    public void setActions(Collection<ActionDeclaration> actions) {
        if (actions == null) {
            this.actions = null;
            return;
        }
        this.actions = new ArrayList<ActionDeclaration>(actions);
    }

    public StageDeclaration withActions(ActionDeclaration ... actions) {
        if (this.actions == null) {
            this.setActions(new ArrayList<ActionDeclaration>(actions.length));
        }
        for (ActionDeclaration ele : actions) {
            this.actions.add(ele);
        }
        return this;
    }

    public StageDeclaration withActions(Collection<ActionDeclaration> actions) {
        this.setActions(actions);
        return this;
    }

    public void setOnFailure(FailureConditions onFailure) {
        this.onFailure = onFailure;
    }

    public FailureConditions getOnFailure() {
        return this.onFailure;
    }

    public StageDeclaration withOnFailure(FailureConditions onFailure) {
        this.setOnFailure(onFailure);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getBlockers() != null) {
            sb.append("Blockers: ").append(this.getBlockers()).append(",");
        }
        if (this.getActions() != null) {
            sb.append("Actions: ").append(this.getActions()).append(",");
        }
        if (this.getOnFailure() != null) {
            sb.append("OnFailure: ").append(this.getOnFailure());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StageDeclaration)) {
            return false;
        }
        StageDeclaration other = (StageDeclaration)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getBlockers() == null ^ this.getBlockers() == null) {
            return false;
        }
        if (other.getBlockers() != null && !other.getBlockers().equals(this.getBlockers())) {
            return false;
        }
        if (other.getActions() == null ^ this.getActions() == null) {
            return false;
        }
        if (other.getActions() != null && !other.getActions().equals(this.getActions())) {
            return false;
        }
        if (other.getOnFailure() == null ^ this.getOnFailure() == null) {
            return false;
        }
        return other.getOnFailure() == null || other.getOnFailure().equals(this.getOnFailure());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getBlockers() == null ? 0 : this.getBlockers().hashCode());
        hashCode = 31 * hashCode + (this.getActions() == null ? 0 : this.getActions().hashCode());
        hashCode = 31 * hashCode + (this.getOnFailure() == null ? 0 : this.getOnFailure().hashCode());
        return hashCode;
    }

    public StageDeclaration clone() {
        try {
            return (StageDeclaration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        StageDeclarationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

