/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codeguruprofiler.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.codeguruprofiler.model.AggregationPeriod;
import com.amazonaws.services.codeguruprofiler.model.FrameMetricDatum;
import com.amazonaws.services.codeguruprofiler.model.TimestampStructure;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BatchGetFrameMetricDataResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private Date endTime;
    private List<TimestampStructure> endTimes;
    private List<FrameMetricDatum> frameMetricData;
    private String resolution;
    private Date startTime;
    private Map<String, List<TimestampStructure>> unprocessedEndTimes;

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public BatchGetFrameMetricDataResult withEndTime(Date endTime) {
        this.setEndTime(endTime);
        return this;
    }

    public List<TimestampStructure> getEndTimes() {
        return this.endTimes;
    }

    public void setEndTimes(Collection<TimestampStructure> endTimes) {
        if (endTimes == null) {
            this.endTimes = null;
            return;
        }
        this.endTimes = new ArrayList<TimestampStructure>(endTimes);
    }

    public BatchGetFrameMetricDataResult withEndTimes(TimestampStructure ... endTimes) {
        if (this.endTimes == null) {
            this.setEndTimes(new ArrayList<TimestampStructure>(endTimes.length));
        }
        for (TimestampStructure ele : endTimes) {
            this.endTimes.add(ele);
        }
        return this;
    }

    public BatchGetFrameMetricDataResult withEndTimes(Collection<TimestampStructure> endTimes) {
        this.setEndTimes(endTimes);
        return this;
    }

    public List<FrameMetricDatum> getFrameMetricData() {
        return this.frameMetricData;
    }

    public void setFrameMetricData(Collection<FrameMetricDatum> frameMetricData) {
        if (frameMetricData == null) {
            this.frameMetricData = null;
            return;
        }
        this.frameMetricData = new ArrayList<FrameMetricDatum>(frameMetricData);
    }

    public BatchGetFrameMetricDataResult withFrameMetricData(FrameMetricDatum ... frameMetricData) {
        if (this.frameMetricData == null) {
            this.setFrameMetricData(new ArrayList<FrameMetricDatum>(frameMetricData.length));
        }
        for (FrameMetricDatum ele : frameMetricData) {
            this.frameMetricData.add(ele);
        }
        return this;
    }

    public BatchGetFrameMetricDataResult withFrameMetricData(Collection<FrameMetricDatum> frameMetricData) {
        this.setFrameMetricData(frameMetricData);
        return this;
    }

    public void setResolution(String resolution) {
        this.resolution = resolution;
    }

    public String getResolution() {
        return this.resolution;
    }

    public BatchGetFrameMetricDataResult withResolution(String resolution) {
        this.setResolution(resolution);
        return this;
    }

    public BatchGetFrameMetricDataResult withResolution(AggregationPeriod resolution) {
        this.resolution = resolution.toString();
        return this;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public BatchGetFrameMetricDataResult withStartTime(Date startTime) {
        this.setStartTime(startTime);
        return this;
    }

    public Map<String, List<TimestampStructure>> getUnprocessedEndTimes() {
        return this.unprocessedEndTimes;
    }

    public void setUnprocessedEndTimes(Map<String, List<TimestampStructure>> unprocessedEndTimes) {
        this.unprocessedEndTimes = unprocessedEndTimes;
    }

    public BatchGetFrameMetricDataResult withUnprocessedEndTimes(Map<String, List<TimestampStructure>> unprocessedEndTimes) {
        this.setUnprocessedEndTimes(unprocessedEndTimes);
        return this;
    }

    public BatchGetFrameMetricDataResult addUnprocessedEndTimesEntry(String key, List<TimestampStructure> value) {
        if (null == this.unprocessedEndTimes) {
            this.unprocessedEndTimes = new HashMap<String, List<TimestampStructure>>();
        }
        if (this.unprocessedEndTimes.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.unprocessedEndTimes.put(key, value);
        return this;
    }

    public BatchGetFrameMetricDataResult clearUnprocessedEndTimesEntries() {
        this.unprocessedEndTimes = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEndTime() != null) {
            sb.append("EndTime: ").append(this.getEndTime()).append(",");
        }
        if (this.getEndTimes() != null) {
            sb.append("EndTimes: ").append(this.getEndTimes()).append(",");
        }
        if (this.getFrameMetricData() != null) {
            sb.append("FrameMetricData: ").append(this.getFrameMetricData()).append(",");
        }
        if (this.getResolution() != null) {
            sb.append("Resolution: ").append(this.getResolution()).append(",");
        }
        if (this.getStartTime() != null) {
            sb.append("StartTime: ").append(this.getStartTime()).append(",");
        }
        if (this.getUnprocessedEndTimes() != null) {
            sb.append("UnprocessedEndTimes: ").append(this.getUnprocessedEndTimes());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetFrameMetricDataResult)) {
            return false;
        }
        BatchGetFrameMetricDataResult other = (BatchGetFrameMetricDataResult)obj;
        if (other.getEndTime() == null ^ this.getEndTime() == null) {
            return false;
        }
        if (other.getEndTime() != null && !other.getEndTime().equals(this.getEndTime())) {
            return false;
        }
        if (other.getEndTimes() == null ^ this.getEndTimes() == null) {
            return false;
        }
        if (other.getEndTimes() != null && !other.getEndTimes().equals(this.getEndTimes())) {
            return false;
        }
        if (other.getFrameMetricData() == null ^ this.getFrameMetricData() == null) {
            return false;
        }
        if (other.getFrameMetricData() != null && !other.getFrameMetricData().equals(this.getFrameMetricData())) {
            return false;
        }
        if (other.getResolution() == null ^ this.getResolution() == null) {
            return false;
        }
        if (other.getResolution() != null && !other.getResolution().equals(this.getResolution())) {
            return false;
        }
        if (other.getStartTime() == null ^ this.getStartTime() == null) {
            return false;
        }
        if (other.getStartTime() != null && !other.getStartTime().equals(this.getStartTime())) {
            return false;
        }
        if (other.getUnprocessedEndTimes() == null ^ this.getUnprocessedEndTimes() == null) {
            return false;
        }
        return other.getUnprocessedEndTimes() == null || other.getUnprocessedEndTimes().equals(this.getUnprocessedEndTimes());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEndTime() == null ? 0 : this.getEndTime().hashCode());
        hashCode = 31 * hashCode + (this.getEndTimes() == null ? 0 : this.getEndTimes().hashCode());
        hashCode = 31 * hashCode + (this.getFrameMetricData() == null ? 0 : this.getFrameMetricData().hashCode());
        hashCode = 31 * hashCode + (this.getResolution() == null ? 0 : this.getResolution().hashCode());
        hashCode = 31 * hashCode + (this.getStartTime() == null ? 0 : this.getStartTime().hashCode());
        hashCode = 31 * hashCode + (this.getUnprocessedEndTimes() == null ? 0 : this.getUnprocessedEndTimes().hashCode());
        return hashCode;
    }

    public BatchGetFrameMetricDataResult clone() {
        try {
            return (BatchGetFrameMetricDataResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

