/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codeconnections;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.codeconnections.AWSCodeConnectionsAsync;
import com.amazonaws.services.codeconnections.AWSCodeConnectionsAsyncClientBuilder;
import com.amazonaws.services.codeconnections.AWSCodeConnectionsClient;
import com.amazonaws.services.codeconnections.model.CreateConnectionRequest;
import com.amazonaws.services.codeconnections.model.CreateConnectionResult;
import com.amazonaws.services.codeconnections.model.CreateHostRequest;
import com.amazonaws.services.codeconnections.model.CreateHostResult;
import com.amazonaws.services.codeconnections.model.CreateRepositoryLinkRequest;
import com.amazonaws.services.codeconnections.model.CreateRepositoryLinkResult;
import com.amazonaws.services.codeconnections.model.CreateSyncConfigurationRequest;
import com.amazonaws.services.codeconnections.model.CreateSyncConfigurationResult;
import com.amazonaws.services.codeconnections.model.DeleteConnectionRequest;
import com.amazonaws.services.codeconnections.model.DeleteConnectionResult;
import com.amazonaws.services.codeconnections.model.DeleteHostRequest;
import com.amazonaws.services.codeconnections.model.DeleteHostResult;
import com.amazonaws.services.codeconnections.model.DeleteRepositoryLinkRequest;
import com.amazonaws.services.codeconnections.model.DeleteRepositoryLinkResult;
import com.amazonaws.services.codeconnections.model.DeleteSyncConfigurationRequest;
import com.amazonaws.services.codeconnections.model.DeleteSyncConfigurationResult;
import com.amazonaws.services.codeconnections.model.GetConnectionRequest;
import com.amazonaws.services.codeconnections.model.GetConnectionResult;
import com.amazonaws.services.codeconnections.model.GetHostRequest;
import com.amazonaws.services.codeconnections.model.GetHostResult;
import com.amazonaws.services.codeconnections.model.GetRepositoryLinkRequest;
import com.amazonaws.services.codeconnections.model.GetRepositoryLinkResult;
import com.amazonaws.services.codeconnections.model.GetRepositorySyncStatusRequest;
import com.amazonaws.services.codeconnections.model.GetRepositorySyncStatusResult;
import com.amazonaws.services.codeconnections.model.GetResourceSyncStatusRequest;
import com.amazonaws.services.codeconnections.model.GetResourceSyncStatusResult;
import com.amazonaws.services.codeconnections.model.GetSyncBlockerSummaryRequest;
import com.amazonaws.services.codeconnections.model.GetSyncBlockerSummaryResult;
import com.amazonaws.services.codeconnections.model.GetSyncConfigurationRequest;
import com.amazonaws.services.codeconnections.model.GetSyncConfigurationResult;
import com.amazonaws.services.codeconnections.model.ListConnectionsRequest;
import com.amazonaws.services.codeconnections.model.ListConnectionsResult;
import com.amazonaws.services.codeconnections.model.ListHostsRequest;
import com.amazonaws.services.codeconnections.model.ListHostsResult;
import com.amazonaws.services.codeconnections.model.ListRepositoryLinksRequest;
import com.amazonaws.services.codeconnections.model.ListRepositoryLinksResult;
import com.amazonaws.services.codeconnections.model.ListRepositorySyncDefinitionsRequest;
import com.amazonaws.services.codeconnections.model.ListRepositorySyncDefinitionsResult;
import com.amazonaws.services.codeconnections.model.ListSyncConfigurationsRequest;
import com.amazonaws.services.codeconnections.model.ListSyncConfigurationsResult;
import com.amazonaws.services.codeconnections.model.ListTagsForResourceRequest;
import com.amazonaws.services.codeconnections.model.ListTagsForResourceResult;
import com.amazonaws.services.codeconnections.model.TagResourceRequest;
import com.amazonaws.services.codeconnections.model.TagResourceResult;
import com.amazonaws.services.codeconnections.model.UntagResourceRequest;
import com.amazonaws.services.codeconnections.model.UntagResourceResult;
import com.amazonaws.services.codeconnections.model.UpdateHostRequest;
import com.amazonaws.services.codeconnections.model.UpdateHostResult;
import com.amazonaws.services.codeconnections.model.UpdateRepositoryLinkRequest;
import com.amazonaws.services.codeconnections.model.UpdateRepositoryLinkResult;
import com.amazonaws.services.codeconnections.model.UpdateSyncBlockerRequest;
import com.amazonaws.services.codeconnections.model.UpdateSyncBlockerResult;
import com.amazonaws.services.codeconnections.model.UpdateSyncConfigurationRequest;
import com.amazonaws.services.codeconnections.model.UpdateSyncConfigurationResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSCodeConnectionsAsyncClient
extends AWSCodeConnectionsClient
implements AWSCodeConnectionsAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSCodeConnectionsAsyncClientBuilder asyncBuilder() {
        return AWSCodeConnectionsAsyncClientBuilder.standard();
    }

    AWSCodeConnectionsAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AWSCodeConnectionsAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CreateConnectionResult> createConnectionAsync(CreateConnectionRequest request) {
        return this.createConnectionAsync(request, null);
    }

    @Override
    public Future<CreateConnectionResult> createConnectionAsync(CreateConnectionRequest request, final AsyncHandler<CreateConnectionRequest, CreateConnectionResult> asyncHandler) {
        final CreateConnectionRequest finalRequest = (CreateConnectionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateConnectionResult>(){

            @Override
            public CreateConnectionResult call() throws Exception {
                CreateConnectionResult result = null;
                try {
                    result = AWSCodeConnectionsAsyncClient.this.executeCreateConnection(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateHostResult> createHostAsync(CreateHostRequest request) {
        return this.createHostAsync(request, null);
    }

    @Override
    public Future<CreateHostResult> createHostAsync(CreateHostRequest request, final AsyncHandler<CreateHostRequest, CreateHostResult> asyncHandler) {
        final CreateHostRequest finalRequest = (CreateHostRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateHostResult>(){

            @Override
            public CreateHostResult call() throws Exception {
                CreateHostResult result = null;
                try {
                    result = AWSCodeConnectionsAsyncClient.this.executeCreateHost(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateRepositoryLinkResult> createRepositoryLinkAsync(CreateRepositoryLinkRequest request) {
        return this.createRepositoryLinkAsync(request, null);
    }

    @Override
    public Future<CreateRepositoryLinkResult> createRepositoryLinkAsync(CreateRepositoryLinkRequest request, final AsyncHandler<CreateRepositoryLinkRequest, CreateRepositoryLinkResult> asyncHandler) {
        final CreateRepositoryLinkRequest finalRequest = (CreateRepositoryLinkRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateRepositoryLinkResult>(){

            @Override
            public CreateRepositoryLinkResult call() throws Exception {
                CreateRepositoryLinkResult result = null;
                try {
                    result = AWSCodeConnectionsAsyncClient.this.executeCreateRepositoryLink(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateSyncConfigurationResult> createSyncConfigurationAsync(CreateSyncConfigurationRequest request) {
        return this.createSyncConfigurationAsync(request, null);
    }

    @Override
    public Future<CreateSyncConfigurationResult> createSyncConfigurationAsync(CreateSyncConfigurationRequest request, final AsyncHandler<CreateSyncConfigurationRequest, CreateSyncConfigurationResult> asyncHandler) {
        final CreateSyncConfigurationRequest finalRequest = (CreateSyncConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateSyncConfigurationResult>(){

            @Override
            public CreateSyncConfigurationResult call() throws Exception {
                CreateSyncConfigurationResult result = null;
                try {
                    result = AWSCodeConnectionsAsyncClient.this.executeCreateSyncConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteConnectionResult> deleteConnectionAsync(DeleteConnectionRequest request) {
        return this.deleteConnectionAsync(request, null);
    }

    @Override
    public Future<DeleteConnectionResult> deleteConnectionAsync(DeleteConnectionRequest request, final AsyncHandler<DeleteConnectionRequest, DeleteConnectionResult> asyncHandler) {
        final DeleteConnectionRequest finalRequest = (DeleteConnectionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteConnectionResult>(){

            @Override
            public DeleteConnectionResult call() throws Exception {
                DeleteConnectionResult result = null;
                try {
                    result = AWSCodeConnectionsAsyncClient.this.executeDeleteConnection(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteHostResult> deleteHostAsync(DeleteHostRequest request) {
        return this.deleteHostAsync(request, null);
    }

    @Override
    public Future<DeleteHostResult> deleteHostAsync(DeleteHostRequest request, final AsyncHandler<DeleteHostRequest, DeleteHostResult> asyncHandler) {
        final DeleteHostRequest finalRequest = (DeleteHostRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteHostResult>(){

            @Override
            public DeleteHostResult call() throws Exception {
                DeleteHostResult result = null;
                try {
                    result = AWSCodeConnectionsAsyncClient.this.executeDeleteHost(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteRepositoryLinkResult> deleteRepositoryLinkAsync(DeleteRepositoryLinkRequest request) {
        return this.deleteRepositoryLinkAsync(request, null);
    }

    @Override
    public Future<DeleteRepositoryLinkResult> deleteRepositoryLinkAsync(DeleteRepositoryLinkRequest request, final AsyncHandler<DeleteRepositoryLinkRequest, DeleteRepositoryLinkResult> asyncHandler) {
        final DeleteRepositoryLinkRequest finalRequest = (DeleteRepositoryLinkRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteRepositoryLinkResult>(){

            @Override
            public DeleteRepositoryLinkResult call() throws Exception {
                DeleteRepositoryLinkResult result = null;
                try {
                    result = AWSCodeConnectionsAsyncClient.this.executeDeleteRepositoryLink(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteSyncConfigurationResult> deleteSyncConfigurationAsync(DeleteSyncConfigurationRequest request) {
        return this.deleteSyncConfigurationAsync(request, null);
    }

    @Override
    public Future<DeleteSyncConfigurationResult> deleteSyncConfigurationAsync(DeleteSyncConfigurationRequest request, final AsyncHandler<DeleteSyncConfigurationRequest, DeleteSyncConfigurationResult> asyncHandler) {
        final DeleteSyncConfigurationRequest finalRequest = (DeleteSyncConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteSyncConfigurationResult>(){

            @Override
            public DeleteSyncConfigurationResult call() throws Exception {
                DeleteSyncConfigurationResult result = null;
                try {
                    result = AWSCodeConnectionsAsyncClient.this.executeDeleteSyncConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetConnectionResult> getConnectionAsync(GetConnectionRequest request) {
        return this.getConnectionAsync(request, null);
    }

    @Override
    public Future<GetConnectionResult> getConnectionAsync(GetConnectionRequest request, final AsyncHandler<GetConnectionRequest, GetConnectionResult> asyncHandler) {
        final GetConnectionRequest finalRequest = (GetConnectionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetConnectionResult>(){

            @Override
            public GetConnectionResult call() throws Exception {
                GetConnectionResult result = null;
                try {
                    result = AWSCodeConnectionsAsyncClient.this.executeGetConnection(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetHostResult> getHostAsync(GetHostRequest request) {
        return this.getHostAsync(request, null);
    }

    @Override
    public Future<GetHostResult> getHostAsync(GetHostRequest request, final AsyncHandler<GetHostRequest, GetHostResult> asyncHandler) {
        final GetHostRequest finalRequest = (GetHostRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetHostResult>(){

            @Override
            public GetHostResult call() throws Exception {
                GetHostResult result = null;
                try {
                    result = AWSCodeConnectionsAsyncClient.this.executeGetHost(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetRepositoryLinkResult> getRepositoryLinkAsync(GetRepositoryLinkRequest request) {
        return this.getRepositoryLinkAsync(request, null);
    }

    @Override
    public Future<GetRepositoryLinkResult> getRepositoryLinkAsync(GetRepositoryLinkRequest request, final AsyncHandler<GetRepositoryLinkRequest, GetRepositoryLinkResult> asyncHandler) {
        final GetRepositoryLinkRequest finalRequest = (GetRepositoryLinkRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetRepositoryLinkResult>(){

            @Override
            public GetRepositoryLinkResult call() throws Exception {
                GetRepositoryLinkResult result = null;
                try {
                    result = AWSCodeConnectionsAsyncClient.this.executeGetRepositoryLink(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetRepositorySyncStatusResult> getRepositorySyncStatusAsync(GetRepositorySyncStatusRequest request) {
        return this.getRepositorySyncStatusAsync(request, null);
    }

    @Override
    public Future<GetRepositorySyncStatusResult> getRepositorySyncStatusAsync(GetRepositorySyncStatusRequest request, final AsyncHandler<GetRepositorySyncStatusRequest, GetRepositorySyncStatusResult> asyncHandler) {
        final GetRepositorySyncStatusRequest finalRequest = (GetRepositorySyncStatusRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetRepositorySyncStatusResult>(){

            @Override
            public GetRepositorySyncStatusResult call() throws Exception {
                GetRepositorySyncStatusResult result = null;
                try {
                    result = AWSCodeConnectionsAsyncClient.this.executeGetRepositorySyncStatus(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetResourceSyncStatusResult> getResourceSyncStatusAsync(GetResourceSyncStatusRequest request) {
        return this.getResourceSyncStatusAsync(request, null);
    }

    @Override
    public Future<GetResourceSyncStatusResult> getResourceSyncStatusAsync(GetResourceSyncStatusRequest request, final AsyncHandler<GetResourceSyncStatusRequest, GetResourceSyncStatusResult> asyncHandler) {
        final GetResourceSyncStatusRequest finalRequest = (GetResourceSyncStatusRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetResourceSyncStatusResult>(){

            @Override
            public GetResourceSyncStatusResult call() throws Exception {
                GetResourceSyncStatusResult result = null;
                try {
                    result = AWSCodeConnectionsAsyncClient.this.executeGetResourceSyncStatus(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetSyncBlockerSummaryResult> getSyncBlockerSummaryAsync(GetSyncBlockerSummaryRequest request) {
        return this.getSyncBlockerSummaryAsync(request, null);
    }

    @Override
    public Future<GetSyncBlockerSummaryResult> getSyncBlockerSummaryAsync(GetSyncBlockerSummaryRequest request, final AsyncHandler<GetSyncBlockerSummaryRequest, GetSyncBlockerSummaryResult> asyncHandler) {
        final GetSyncBlockerSummaryRequest finalRequest = (GetSyncBlockerSummaryRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetSyncBlockerSummaryResult>(){

            @Override
            public GetSyncBlockerSummaryResult call() throws Exception {
                GetSyncBlockerSummaryResult result = null;
                try {
                    result = AWSCodeConnectionsAsyncClient.this.executeGetSyncBlockerSummary(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetSyncConfigurationResult> getSyncConfigurationAsync(GetSyncConfigurationRequest request) {
        return this.getSyncConfigurationAsync(request, null);
    }

    @Override
    public Future<GetSyncConfigurationResult> getSyncConfigurationAsync(GetSyncConfigurationRequest request, final AsyncHandler<GetSyncConfigurationRequest, GetSyncConfigurationResult> asyncHandler) {
        final GetSyncConfigurationRequest finalRequest = (GetSyncConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetSyncConfigurationResult>(){

            @Override
            public GetSyncConfigurationResult call() throws Exception {
                GetSyncConfigurationResult result = null;
                try {
                    result = AWSCodeConnectionsAsyncClient.this.executeGetSyncConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListConnectionsResult> listConnectionsAsync(ListConnectionsRequest request) {
        return this.listConnectionsAsync(request, null);
    }

    @Override
    public Future<ListConnectionsResult> listConnectionsAsync(ListConnectionsRequest request, final AsyncHandler<ListConnectionsRequest, ListConnectionsResult> asyncHandler) {
        final ListConnectionsRequest finalRequest = (ListConnectionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListConnectionsResult>(){

            @Override
            public ListConnectionsResult call() throws Exception {
                ListConnectionsResult result = null;
                try {
                    result = AWSCodeConnectionsAsyncClient.this.executeListConnections(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListHostsResult> listHostsAsync(ListHostsRequest request) {
        return this.listHostsAsync(request, null);
    }

    @Override
    public Future<ListHostsResult> listHostsAsync(ListHostsRequest request, final AsyncHandler<ListHostsRequest, ListHostsResult> asyncHandler) {
        final ListHostsRequest finalRequest = (ListHostsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListHostsResult>(){

            @Override
            public ListHostsResult call() throws Exception {
                ListHostsResult result = null;
                try {
                    result = AWSCodeConnectionsAsyncClient.this.executeListHosts(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListRepositoryLinksResult> listRepositoryLinksAsync(ListRepositoryLinksRequest request) {
        return this.listRepositoryLinksAsync(request, null);
    }

    @Override
    public Future<ListRepositoryLinksResult> listRepositoryLinksAsync(ListRepositoryLinksRequest request, final AsyncHandler<ListRepositoryLinksRequest, ListRepositoryLinksResult> asyncHandler) {
        final ListRepositoryLinksRequest finalRequest = (ListRepositoryLinksRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListRepositoryLinksResult>(){

            @Override
            public ListRepositoryLinksResult call() throws Exception {
                ListRepositoryLinksResult result = null;
                try {
                    result = AWSCodeConnectionsAsyncClient.this.executeListRepositoryLinks(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListRepositorySyncDefinitionsResult> listRepositorySyncDefinitionsAsync(ListRepositorySyncDefinitionsRequest request) {
        return this.listRepositorySyncDefinitionsAsync(request, null);
    }

    @Override
    public Future<ListRepositorySyncDefinitionsResult> listRepositorySyncDefinitionsAsync(ListRepositorySyncDefinitionsRequest request, final AsyncHandler<ListRepositorySyncDefinitionsRequest, ListRepositorySyncDefinitionsResult> asyncHandler) {
        final ListRepositorySyncDefinitionsRequest finalRequest = (ListRepositorySyncDefinitionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListRepositorySyncDefinitionsResult>(){

            @Override
            public ListRepositorySyncDefinitionsResult call() throws Exception {
                ListRepositorySyncDefinitionsResult result = null;
                try {
                    result = AWSCodeConnectionsAsyncClient.this.executeListRepositorySyncDefinitions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListSyncConfigurationsResult> listSyncConfigurationsAsync(ListSyncConfigurationsRequest request) {
        return this.listSyncConfigurationsAsync(request, null);
    }

    @Override
    public Future<ListSyncConfigurationsResult> listSyncConfigurationsAsync(ListSyncConfigurationsRequest request, final AsyncHandler<ListSyncConfigurationsRequest, ListSyncConfigurationsResult> asyncHandler) {
        final ListSyncConfigurationsRequest finalRequest = (ListSyncConfigurationsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListSyncConfigurationsResult>(){

            @Override
            public ListSyncConfigurationsResult call() throws Exception {
                ListSyncConfigurationsResult result = null;
                try {
                    result = AWSCodeConnectionsAsyncClient.this.executeListSyncConfigurations(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AWSCodeConnectionsAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AWSCodeConnectionsAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AWSCodeConnectionsAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateHostResult> updateHostAsync(UpdateHostRequest request) {
        return this.updateHostAsync(request, null);
    }

    @Override
    public Future<UpdateHostResult> updateHostAsync(UpdateHostRequest request, final AsyncHandler<UpdateHostRequest, UpdateHostResult> asyncHandler) {
        final UpdateHostRequest finalRequest = (UpdateHostRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateHostResult>(){

            @Override
            public UpdateHostResult call() throws Exception {
                UpdateHostResult result = null;
                try {
                    result = AWSCodeConnectionsAsyncClient.this.executeUpdateHost(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateRepositoryLinkResult> updateRepositoryLinkAsync(UpdateRepositoryLinkRequest request) {
        return this.updateRepositoryLinkAsync(request, null);
    }

    @Override
    public Future<UpdateRepositoryLinkResult> updateRepositoryLinkAsync(UpdateRepositoryLinkRequest request, final AsyncHandler<UpdateRepositoryLinkRequest, UpdateRepositoryLinkResult> asyncHandler) {
        final UpdateRepositoryLinkRequest finalRequest = (UpdateRepositoryLinkRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateRepositoryLinkResult>(){

            @Override
            public UpdateRepositoryLinkResult call() throws Exception {
                UpdateRepositoryLinkResult result = null;
                try {
                    result = AWSCodeConnectionsAsyncClient.this.executeUpdateRepositoryLink(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateSyncBlockerResult> updateSyncBlockerAsync(UpdateSyncBlockerRequest request) {
        return this.updateSyncBlockerAsync(request, null);
    }

    @Override
    public Future<UpdateSyncBlockerResult> updateSyncBlockerAsync(UpdateSyncBlockerRequest request, final AsyncHandler<UpdateSyncBlockerRequest, UpdateSyncBlockerResult> asyncHandler) {
        final UpdateSyncBlockerRequest finalRequest = (UpdateSyncBlockerRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateSyncBlockerResult>(){

            @Override
            public UpdateSyncBlockerResult call() throws Exception {
                UpdateSyncBlockerResult result = null;
                try {
                    result = AWSCodeConnectionsAsyncClient.this.executeUpdateSyncBlocker(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateSyncConfigurationResult> updateSyncConfigurationAsync(UpdateSyncConfigurationRequest request) {
        return this.updateSyncConfigurationAsync(request, null);
    }

    @Override
    public Future<UpdateSyncConfigurationResult> updateSyncConfigurationAsync(UpdateSyncConfigurationRequest request, final AsyncHandler<UpdateSyncConfigurationRequest, UpdateSyncConfigurationResult> asyncHandler) {
        final UpdateSyncConfigurationRequest finalRequest = (UpdateSyncConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateSyncConfigurationResult>(){

            @Override
            public UpdateSyncConfigurationResult call() throws Exception {
                UpdateSyncConfigurationResult result = null;
                try {
                    result = AWSCodeConnectionsAsyncClient.this.executeUpdateSyncConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

