/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codecommit.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.codecommit.model.DeleteFileEntry;
import com.amazonaws.services.codecommit.model.ReplaceContentEntry;
import com.amazonaws.services.codecommit.model.SetFileModeEntry;
import com.amazonaws.services.codecommit.model.transform.ConflictResolutionMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ConflictResolution
implements Serializable,
Cloneable,
StructuredPojo {
    private List<ReplaceContentEntry> replaceContents;
    private List<DeleteFileEntry> deleteFiles;
    private List<SetFileModeEntry> setFileModes;

    public List<ReplaceContentEntry> getReplaceContents() {
        return this.replaceContents;
    }

    public void setReplaceContents(Collection<ReplaceContentEntry> replaceContents) {
        if (replaceContents == null) {
            this.replaceContents = null;
            return;
        }
        this.replaceContents = new ArrayList<ReplaceContentEntry>(replaceContents);
    }

    public ConflictResolution withReplaceContents(ReplaceContentEntry ... replaceContents) {
        if (this.replaceContents == null) {
            this.setReplaceContents(new ArrayList<ReplaceContentEntry>(replaceContents.length));
        }
        for (ReplaceContentEntry ele : replaceContents) {
            this.replaceContents.add(ele);
        }
        return this;
    }

    public ConflictResolution withReplaceContents(Collection<ReplaceContentEntry> replaceContents) {
        this.setReplaceContents(replaceContents);
        return this;
    }

    public List<DeleteFileEntry> getDeleteFiles() {
        return this.deleteFiles;
    }

    public void setDeleteFiles(Collection<DeleteFileEntry> deleteFiles) {
        if (deleteFiles == null) {
            this.deleteFiles = null;
            return;
        }
        this.deleteFiles = new ArrayList<DeleteFileEntry>(deleteFiles);
    }

    public ConflictResolution withDeleteFiles(DeleteFileEntry ... deleteFiles) {
        if (this.deleteFiles == null) {
            this.setDeleteFiles(new ArrayList<DeleteFileEntry>(deleteFiles.length));
        }
        for (DeleteFileEntry ele : deleteFiles) {
            this.deleteFiles.add(ele);
        }
        return this;
    }

    public ConflictResolution withDeleteFiles(Collection<DeleteFileEntry> deleteFiles) {
        this.setDeleteFiles(deleteFiles);
        return this;
    }

    public List<SetFileModeEntry> getSetFileModes() {
        return this.setFileModes;
    }

    public void setSetFileModes(Collection<SetFileModeEntry> setFileModes) {
        if (setFileModes == null) {
            this.setFileModes = null;
            return;
        }
        this.setFileModes = new ArrayList<SetFileModeEntry>(setFileModes);
    }

    public ConflictResolution withSetFileModes(SetFileModeEntry ... setFileModes) {
        if (this.setFileModes == null) {
            this.setSetFileModes(new ArrayList<SetFileModeEntry>(setFileModes.length));
        }
        for (SetFileModeEntry ele : setFileModes) {
            this.setFileModes.add(ele);
        }
        return this;
    }

    public ConflictResolution withSetFileModes(Collection<SetFileModeEntry> setFileModes) {
        this.setSetFileModes(setFileModes);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getReplaceContents() != null) {
            sb.append("ReplaceContents: ").append(this.getReplaceContents()).append(",");
        }
        if (this.getDeleteFiles() != null) {
            sb.append("DeleteFiles: ").append(this.getDeleteFiles()).append(",");
        }
        if (this.getSetFileModes() != null) {
            sb.append("SetFileModes: ").append(this.getSetFileModes());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConflictResolution)) {
            return false;
        }
        ConflictResolution other = (ConflictResolution)obj;
        if (other.getReplaceContents() == null ^ this.getReplaceContents() == null) {
            return false;
        }
        if (other.getReplaceContents() != null && !other.getReplaceContents().equals(this.getReplaceContents())) {
            return false;
        }
        if (other.getDeleteFiles() == null ^ this.getDeleteFiles() == null) {
            return false;
        }
        if (other.getDeleteFiles() != null && !other.getDeleteFiles().equals(this.getDeleteFiles())) {
            return false;
        }
        if (other.getSetFileModes() == null ^ this.getSetFileModes() == null) {
            return false;
        }
        return other.getSetFileModes() == null || other.getSetFileModes().equals(this.getSetFileModes());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getReplaceContents() == null ? 0 : this.getReplaceContents().hashCode());
        hashCode = 31 * hashCode + (this.getDeleteFiles() == null ? 0 : this.getDeleteFiles().hashCode());
        hashCode = 31 * hashCode + (this.getSetFileModes() == null ? 0 : this.getSetFileModes().hashCode());
        return hashCode;
    }

    public ConflictResolution clone() {
        try {
            return (ConflictResolution)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ConflictResolutionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

