/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codecommit.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.codecommit.model.MergeOptionTypeEnum;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GetMergeOptionsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<String> mergeOptions;
    private String sourceCommitId;
    private String destinationCommitId;
    private String baseCommitId;

    public List<String> getMergeOptions() {
        return this.mergeOptions;
    }

    public void setMergeOptions(Collection<String> mergeOptions) {
        if (mergeOptions == null) {
            this.mergeOptions = null;
            return;
        }
        this.mergeOptions = new ArrayList<String>(mergeOptions);
    }

    public GetMergeOptionsResult withMergeOptions(String ... mergeOptions) {
        if (this.mergeOptions == null) {
            this.setMergeOptions(new ArrayList<String>(mergeOptions.length));
        }
        for (String ele : mergeOptions) {
            this.mergeOptions.add(ele);
        }
        return this;
    }

    public GetMergeOptionsResult withMergeOptions(Collection<String> mergeOptions) {
        this.setMergeOptions(mergeOptions);
        return this;
    }

    public GetMergeOptionsResult withMergeOptions(MergeOptionTypeEnum ... mergeOptions) {
        ArrayList<String> mergeOptionsCopy = new ArrayList<String>(mergeOptions.length);
        for (MergeOptionTypeEnum value : mergeOptions) {
            mergeOptionsCopy.add(value.toString());
        }
        if (this.getMergeOptions() == null) {
            this.setMergeOptions(mergeOptionsCopy);
        } else {
            this.getMergeOptions().addAll(mergeOptionsCopy);
        }
        return this;
    }

    public void setSourceCommitId(String sourceCommitId) {
        this.sourceCommitId = sourceCommitId;
    }

    public String getSourceCommitId() {
        return this.sourceCommitId;
    }

    public GetMergeOptionsResult withSourceCommitId(String sourceCommitId) {
        this.setSourceCommitId(sourceCommitId);
        return this;
    }

    public void setDestinationCommitId(String destinationCommitId) {
        this.destinationCommitId = destinationCommitId;
    }

    public String getDestinationCommitId() {
        return this.destinationCommitId;
    }

    public GetMergeOptionsResult withDestinationCommitId(String destinationCommitId) {
        this.setDestinationCommitId(destinationCommitId);
        return this;
    }

    public void setBaseCommitId(String baseCommitId) {
        this.baseCommitId = baseCommitId;
    }

    public String getBaseCommitId() {
        return this.baseCommitId;
    }

    public GetMergeOptionsResult withBaseCommitId(String baseCommitId) {
        this.setBaseCommitId(baseCommitId);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMergeOptions() != null) {
            sb.append("MergeOptions: ").append(this.getMergeOptions()).append(",");
        }
        if (this.getSourceCommitId() != null) {
            sb.append("SourceCommitId: ").append(this.getSourceCommitId()).append(",");
        }
        if (this.getDestinationCommitId() != null) {
            sb.append("DestinationCommitId: ").append(this.getDestinationCommitId()).append(",");
        }
        if (this.getBaseCommitId() != null) {
            sb.append("BaseCommitId: ").append(this.getBaseCommitId());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMergeOptionsResult)) {
            return false;
        }
        GetMergeOptionsResult other = (GetMergeOptionsResult)obj;
        if (other.getMergeOptions() == null ^ this.getMergeOptions() == null) {
            return false;
        }
        if (other.getMergeOptions() != null && !other.getMergeOptions().equals(this.getMergeOptions())) {
            return false;
        }
        if (other.getSourceCommitId() == null ^ this.getSourceCommitId() == null) {
            return false;
        }
        if (other.getSourceCommitId() != null && !other.getSourceCommitId().equals(this.getSourceCommitId())) {
            return false;
        }
        if (other.getDestinationCommitId() == null ^ this.getDestinationCommitId() == null) {
            return false;
        }
        if (other.getDestinationCommitId() != null && !other.getDestinationCommitId().equals(this.getDestinationCommitId())) {
            return false;
        }
        if (other.getBaseCommitId() == null ^ this.getBaseCommitId() == null) {
            return false;
        }
        return other.getBaseCommitId() == null || other.getBaseCommitId().equals(this.getBaseCommitId());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMergeOptions() == null ? 0 : this.getMergeOptions().hashCode());
        hashCode = 31 * hashCode + (this.getSourceCommitId() == null ? 0 : this.getSourceCommitId().hashCode());
        hashCode = 31 * hashCode + (this.getDestinationCommitId() == null ? 0 : this.getDestinationCommitId().hashCode());
        hashCode = 31 * hashCode + (this.getBaseCommitId() == null ? 0 : this.getBaseCommitId().hashCode());
        return hashCode;
    }

    public GetMergeOptionsResult clone() {
        try {
            return (GetMergeOptionsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

