/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codecommit.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.codecommit.model.Commit;
import com.amazonaws.services.codecommit.model.transform.FileVersionMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class FileVersion
implements Serializable,
Cloneable,
StructuredPojo {
    private Commit commit;
    private String blobId;
    private String path;
    private List<String> revisionChildren;

    public void setCommit(Commit commit) {
        this.commit = commit;
    }

    public Commit getCommit() {
        return this.commit;
    }

    public FileVersion withCommit(Commit commit) {
        this.setCommit(commit);
        return this;
    }

    public void setBlobId(String blobId) {
        this.blobId = blobId;
    }

    public String getBlobId() {
        return this.blobId;
    }

    public FileVersion withBlobId(String blobId) {
        this.setBlobId(blobId);
        return this;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public FileVersion withPath(String path) {
        this.setPath(path);
        return this;
    }

    public List<String> getRevisionChildren() {
        return this.revisionChildren;
    }

    public void setRevisionChildren(Collection<String> revisionChildren) {
        if (revisionChildren == null) {
            this.revisionChildren = null;
            return;
        }
        this.revisionChildren = new ArrayList<String>(revisionChildren);
    }

    public FileVersion withRevisionChildren(String ... revisionChildren) {
        if (this.revisionChildren == null) {
            this.setRevisionChildren(new ArrayList<String>(revisionChildren.length));
        }
        for (String ele : revisionChildren) {
            this.revisionChildren.add(ele);
        }
        return this;
    }

    public FileVersion withRevisionChildren(Collection<String> revisionChildren) {
        this.setRevisionChildren(revisionChildren);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCommit() != null) {
            sb.append("Commit: ").append(this.getCommit()).append(",");
        }
        if (this.getBlobId() != null) {
            sb.append("BlobId: ").append(this.getBlobId()).append(",");
        }
        if (this.getPath() != null) {
            sb.append("Path: ").append(this.getPath()).append(",");
        }
        if (this.getRevisionChildren() != null) {
            sb.append("RevisionChildren: ").append(this.getRevisionChildren());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FileVersion)) {
            return false;
        }
        FileVersion other = (FileVersion)obj;
        if (other.getCommit() == null ^ this.getCommit() == null) {
            return false;
        }
        if (other.getCommit() != null && !other.getCommit().equals(this.getCommit())) {
            return false;
        }
        if (other.getBlobId() == null ^ this.getBlobId() == null) {
            return false;
        }
        if (other.getBlobId() != null && !other.getBlobId().equals(this.getBlobId())) {
            return false;
        }
        if (other.getPath() == null ^ this.getPath() == null) {
            return false;
        }
        if (other.getPath() != null && !other.getPath().equals(this.getPath())) {
            return false;
        }
        if (other.getRevisionChildren() == null ^ this.getRevisionChildren() == null) {
            return false;
        }
        return other.getRevisionChildren() == null || other.getRevisionChildren().equals(this.getRevisionChildren());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCommit() == null ? 0 : this.getCommit().hashCode());
        hashCode = 31 * hashCode + (this.getBlobId() == null ? 0 : this.getBlobId().hashCode());
        hashCode = 31 * hashCode + (this.getPath() == null ? 0 : this.getPath().hashCode());
        hashCode = 31 * hashCode + (this.getRevisionChildren() == null ? 0 : this.getRevisionChildren().hashCode());
        return hashCode;
    }

    public FileVersion clone() {
        try {
            return (FileVersion)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FileVersionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

