/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codebuild.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.codebuild.model.S3LogsConfig;

@SdkInternalApi
public class S3LogsConfigMarshaller {
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("status").build();
    private static final MarshallingInfo<String> LOCATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("location").build();
    private static final MarshallingInfo<Boolean> ENCRYPTIONDISABLED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("encryptionDisabled").build();
    private static final S3LogsConfigMarshaller instance = new S3LogsConfigMarshaller();

    public static S3LogsConfigMarshaller getInstance() {
        return instance;
    }

    public void marshall(S3LogsConfig s3LogsConfig, ProtocolMarshaller protocolMarshaller) {
        if (s3LogsConfig == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)s3LogsConfig.getStatus(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)s3LogsConfig.getLocation(), LOCATION_BINDING);
            protocolMarshaller.marshall((Object)s3LogsConfig.getEncryptionDisabled(), ENCRYPTIONDISABLED_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

