/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codebuild.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.codebuild.model.BuildArtifacts;
import com.amazonaws.services.codebuild.model.BuildBatchPhase;
import com.amazonaws.services.codebuild.model.BuildGroup;
import com.amazonaws.services.codebuild.model.LogsConfig;
import com.amazonaws.services.codebuild.model.ProjectBuildBatchConfig;
import com.amazonaws.services.codebuild.model.ProjectCache;
import com.amazonaws.services.codebuild.model.ProjectEnvironment;
import com.amazonaws.services.codebuild.model.ProjectFileSystemLocation;
import com.amazonaws.services.codebuild.model.ProjectSource;
import com.amazonaws.services.codebuild.model.ProjectSourceVersion;
import com.amazonaws.services.codebuild.model.StatusType;
import com.amazonaws.services.codebuild.model.VpcConfig;
import com.amazonaws.services.codebuild.model.transform.BuildBatchMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class BuildBatch
implements Serializable,
Cloneable,
StructuredPojo {
    private String id;
    private String arn;
    private Date startTime;
    private Date endTime;
    private String currentPhase;
    private String buildBatchStatus;
    private String sourceVersion;
    private String resolvedSourceVersion;
    private String projectName;
    private List<BuildBatchPhase> phases;
    private ProjectSource source;
    private List<ProjectSource> secondarySources;
    private List<ProjectSourceVersion> secondarySourceVersions;
    private BuildArtifacts artifacts;
    private List<BuildArtifacts> secondaryArtifacts;
    private ProjectCache cache;
    private ProjectEnvironment environment;
    private String serviceRole;
    private LogsConfig logConfig;
    private Integer buildTimeoutInMinutes;
    private Integer queuedTimeoutInMinutes;
    private Boolean complete;
    private String initiator;
    private VpcConfig vpcConfig;
    private String encryptionKey;
    private Long buildBatchNumber;
    private List<ProjectFileSystemLocation> fileSystemLocations;
    private ProjectBuildBatchConfig buildBatchConfig;
    private List<BuildGroup> buildGroups;

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public BuildBatch withId(String id) {
        this.setId(id);
        return this;
    }

    public void setArn(String arn) {
        this.arn = arn;
    }

    public String getArn() {
        return this.arn;
    }

    public BuildBatch withArn(String arn) {
        this.setArn(arn);
        return this;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public BuildBatch withStartTime(Date startTime) {
        this.setStartTime(startTime);
        return this;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public BuildBatch withEndTime(Date endTime) {
        this.setEndTime(endTime);
        return this;
    }

    public void setCurrentPhase(String currentPhase) {
        this.currentPhase = currentPhase;
    }

    public String getCurrentPhase() {
        return this.currentPhase;
    }

    public BuildBatch withCurrentPhase(String currentPhase) {
        this.setCurrentPhase(currentPhase);
        return this;
    }

    public void setBuildBatchStatus(String buildBatchStatus) {
        this.buildBatchStatus = buildBatchStatus;
    }

    public String getBuildBatchStatus() {
        return this.buildBatchStatus;
    }

    public BuildBatch withBuildBatchStatus(String buildBatchStatus) {
        this.setBuildBatchStatus(buildBatchStatus);
        return this;
    }

    public BuildBatch withBuildBatchStatus(StatusType buildBatchStatus) {
        this.buildBatchStatus = buildBatchStatus.toString();
        return this;
    }

    public void setSourceVersion(String sourceVersion) {
        this.sourceVersion = sourceVersion;
    }

    public String getSourceVersion() {
        return this.sourceVersion;
    }

    public BuildBatch withSourceVersion(String sourceVersion) {
        this.setSourceVersion(sourceVersion);
        return this;
    }

    public void setResolvedSourceVersion(String resolvedSourceVersion) {
        this.resolvedSourceVersion = resolvedSourceVersion;
    }

    public String getResolvedSourceVersion() {
        return this.resolvedSourceVersion;
    }

    public BuildBatch withResolvedSourceVersion(String resolvedSourceVersion) {
        this.setResolvedSourceVersion(resolvedSourceVersion);
        return this;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public BuildBatch withProjectName(String projectName) {
        this.setProjectName(projectName);
        return this;
    }

    public List<BuildBatchPhase> getPhases() {
        return this.phases;
    }

    public void setPhases(Collection<BuildBatchPhase> phases) {
        if (phases == null) {
            this.phases = null;
            return;
        }
        this.phases = new ArrayList<BuildBatchPhase>(phases);
    }

    public BuildBatch withPhases(BuildBatchPhase ... phases) {
        if (this.phases == null) {
            this.setPhases(new ArrayList<BuildBatchPhase>(phases.length));
        }
        for (BuildBatchPhase ele : phases) {
            this.phases.add(ele);
        }
        return this;
    }

    public BuildBatch withPhases(Collection<BuildBatchPhase> phases) {
        this.setPhases(phases);
        return this;
    }

    public void setSource(ProjectSource source) {
        this.source = source;
    }

    public ProjectSource getSource() {
        return this.source;
    }

    public BuildBatch withSource(ProjectSource source) {
        this.setSource(source);
        return this;
    }

    public List<ProjectSource> getSecondarySources() {
        return this.secondarySources;
    }

    public void setSecondarySources(Collection<ProjectSource> secondarySources) {
        if (secondarySources == null) {
            this.secondarySources = null;
            return;
        }
        this.secondarySources = new ArrayList<ProjectSource>(secondarySources);
    }

    public BuildBatch withSecondarySources(ProjectSource ... secondarySources) {
        if (this.secondarySources == null) {
            this.setSecondarySources(new ArrayList<ProjectSource>(secondarySources.length));
        }
        for (ProjectSource ele : secondarySources) {
            this.secondarySources.add(ele);
        }
        return this;
    }

    public BuildBatch withSecondarySources(Collection<ProjectSource> secondarySources) {
        this.setSecondarySources(secondarySources);
        return this;
    }

    public List<ProjectSourceVersion> getSecondarySourceVersions() {
        return this.secondarySourceVersions;
    }

    public void setSecondarySourceVersions(Collection<ProjectSourceVersion> secondarySourceVersions) {
        if (secondarySourceVersions == null) {
            this.secondarySourceVersions = null;
            return;
        }
        this.secondarySourceVersions = new ArrayList<ProjectSourceVersion>(secondarySourceVersions);
    }

    public BuildBatch withSecondarySourceVersions(ProjectSourceVersion ... secondarySourceVersions) {
        if (this.secondarySourceVersions == null) {
            this.setSecondarySourceVersions(new ArrayList<ProjectSourceVersion>(secondarySourceVersions.length));
        }
        for (ProjectSourceVersion ele : secondarySourceVersions) {
            this.secondarySourceVersions.add(ele);
        }
        return this;
    }

    public BuildBatch withSecondarySourceVersions(Collection<ProjectSourceVersion> secondarySourceVersions) {
        this.setSecondarySourceVersions(secondarySourceVersions);
        return this;
    }

    public void setArtifacts(BuildArtifacts artifacts) {
        this.artifacts = artifacts;
    }

    public BuildArtifacts getArtifacts() {
        return this.artifacts;
    }

    public BuildBatch withArtifacts(BuildArtifacts artifacts) {
        this.setArtifacts(artifacts);
        return this;
    }

    public List<BuildArtifacts> getSecondaryArtifacts() {
        return this.secondaryArtifacts;
    }

    public void setSecondaryArtifacts(Collection<BuildArtifacts> secondaryArtifacts) {
        if (secondaryArtifacts == null) {
            this.secondaryArtifacts = null;
            return;
        }
        this.secondaryArtifacts = new ArrayList<BuildArtifacts>(secondaryArtifacts);
    }

    public BuildBatch withSecondaryArtifacts(BuildArtifacts ... secondaryArtifacts) {
        if (this.secondaryArtifacts == null) {
            this.setSecondaryArtifacts(new ArrayList<BuildArtifacts>(secondaryArtifacts.length));
        }
        for (BuildArtifacts ele : secondaryArtifacts) {
            this.secondaryArtifacts.add(ele);
        }
        return this;
    }

    public BuildBatch withSecondaryArtifacts(Collection<BuildArtifacts> secondaryArtifacts) {
        this.setSecondaryArtifacts(secondaryArtifacts);
        return this;
    }

    public void setCache(ProjectCache cache) {
        this.cache = cache;
    }

    public ProjectCache getCache() {
        return this.cache;
    }

    public BuildBatch withCache(ProjectCache cache) {
        this.setCache(cache);
        return this;
    }

    public void setEnvironment(ProjectEnvironment environment) {
        this.environment = environment;
    }

    public ProjectEnvironment getEnvironment() {
        return this.environment;
    }

    public BuildBatch withEnvironment(ProjectEnvironment environment) {
        this.setEnvironment(environment);
        return this;
    }

    public void setServiceRole(String serviceRole) {
        this.serviceRole = serviceRole;
    }

    public String getServiceRole() {
        return this.serviceRole;
    }

    public BuildBatch withServiceRole(String serviceRole) {
        this.setServiceRole(serviceRole);
        return this;
    }

    public void setLogConfig(LogsConfig logConfig) {
        this.logConfig = logConfig;
    }

    public LogsConfig getLogConfig() {
        return this.logConfig;
    }

    public BuildBatch withLogConfig(LogsConfig logConfig) {
        this.setLogConfig(logConfig);
        return this;
    }

    public void setBuildTimeoutInMinutes(Integer buildTimeoutInMinutes) {
        this.buildTimeoutInMinutes = buildTimeoutInMinutes;
    }

    public Integer getBuildTimeoutInMinutes() {
        return this.buildTimeoutInMinutes;
    }

    public BuildBatch withBuildTimeoutInMinutes(Integer buildTimeoutInMinutes) {
        this.setBuildTimeoutInMinutes(buildTimeoutInMinutes);
        return this;
    }

    public void setQueuedTimeoutInMinutes(Integer queuedTimeoutInMinutes) {
        this.queuedTimeoutInMinutes = queuedTimeoutInMinutes;
    }

    public Integer getQueuedTimeoutInMinutes() {
        return this.queuedTimeoutInMinutes;
    }

    public BuildBatch withQueuedTimeoutInMinutes(Integer queuedTimeoutInMinutes) {
        this.setQueuedTimeoutInMinutes(queuedTimeoutInMinutes);
        return this;
    }

    public void setComplete(Boolean complete) {
        this.complete = complete;
    }

    public Boolean getComplete() {
        return this.complete;
    }

    public BuildBatch withComplete(Boolean complete) {
        this.setComplete(complete);
        return this;
    }

    public Boolean isComplete() {
        return this.complete;
    }

    public void setInitiator(String initiator) {
        this.initiator = initiator;
    }

    public String getInitiator() {
        return this.initiator;
    }

    public BuildBatch withInitiator(String initiator) {
        this.setInitiator(initiator);
        return this;
    }

    public void setVpcConfig(VpcConfig vpcConfig) {
        this.vpcConfig = vpcConfig;
    }

    public VpcConfig getVpcConfig() {
        return this.vpcConfig;
    }

    public BuildBatch withVpcConfig(VpcConfig vpcConfig) {
        this.setVpcConfig(vpcConfig);
        return this;
    }

    public void setEncryptionKey(String encryptionKey) {
        this.encryptionKey = encryptionKey;
    }

    public String getEncryptionKey() {
        return this.encryptionKey;
    }

    public BuildBatch withEncryptionKey(String encryptionKey) {
        this.setEncryptionKey(encryptionKey);
        return this;
    }

    public void setBuildBatchNumber(Long buildBatchNumber) {
        this.buildBatchNumber = buildBatchNumber;
    }

    public Long getBuildBatchNumber() {
        return this.buildBatchNumber;
    }

    public BuildBatch withBuildBatchNumber(Long buildBatchNumber) {
        this.setBuildBatchNumber(buildBatchNumber);
        return this;
    }

    public List<ProjectFileSystemLocation> getFileSystemLocations() {
        return this.fileSystemLocations;
    }

    public void setFileSystemLocations(Collection<ProjectFileSystemLocation> fileSystemLocations) {
        if (fileSystemLocations == null) {
            this.fileSystemLocations = null;
            return;
        }
        this.fileSystemLocations = new ArrayList<ProjectFileSystemLocation>(fileSystemLocations);
    }

    public BuildBatch withFileSystemLocations(ProjectFileSystemLocation ... fileSystemLocations) {
        if (this.fileSystemLocations == null) {
            this.setFileSystemLocations(new ArrayList<ProjectFileSystemLocation>(fileSystemLocations.length));
        }
        for (ProjectFileSystemLocation ele : fileSystemLocations) {
            this.fileSystemLocations.add(ele);
        }
        return this;
    }

    public BuildBatch withFileSystemLocations(Collection<ProjectFileSystemLocation> fileSystemLocations) {
        this.setFileSystemLocations(fileSystemLocations);
        return this;
    }

    public void setBuildBatchConfig(ProjectBuildBatchConfig buildBatchConfig) {
        this.buildBatchConfig = buildBatchConfig;
    }

    public ProjectBuildBatchConfig getBuildBatchConfig() {
        return this.buildBatchConfig;
    }

    public BuildBatch withBuildBatchConfig(ProjectBuildBatchConfig buildBatchConfig) {
        this.setBuildBatchConfig(buildBatchConfig);
        return this;
    }

    public List<BuildGroup> getBuildGroups() {
        return this.buildGroups;
    }

    public void setBuildGroups(Collection<BuildGroup> buildGroups) {
        if (buildGroups == null) {
            this.buildGroups = null;
            return;
        }
        this.buildGroups = new ArrayList<BuildGroup>(buildGroups);
    }

    public BuildBatch withBuildGroups(BuildGroup ... buildGroups) {
        if (this.buildGroups == null) {
            this.setBuildGroups(new ArrayList<BuildGroup>(buildGroups.length));
        }
        for (BuildGroup ele : buildGroups) {
            this.buildGroups.add(ele);
        }
        return this;
    }

    public BuildBatch withBuildGroups(Collection<BuildGroup> buildGroups) {
        this.setBuildGroups(buildGroups);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getId() != null) {
            sb.append("Id: ").append(this.getId()).append(",");
        }
        if (this.getArn() != null) {
            sb.append("Arn: ").append(this.getArn()).append(",");
        }
        if (this.getStartTime() != null) {
            sb.append("StartTime: ").append(this.getStartTime()).append(",");
        }
        if (this.getEndTime() != null) {
            sb.append("EndTime: ").append(this.getEndTime()).append(",");
        }
        if (this.getCurrentPhase() != null) {
            sb.append("CurrentPhase: ").append(this.getCurrentPhase()).append(",");
        }
        if (this.getBuildBatchStatus() != null) {
            sb.append("BuildBatchStatus: ").append(this.getBuildBatchStatus()).append(",");
        }
        if (this.getSourceVersion() != null) {
            sb.append("SourceVersion: ").append(this.getSourceVersion()).append(",");
        }
        if (this.getResolvedSourceVersion() != null) {
            sb.append("ResolvedSourceVersion: ").append(this.getResolvedSourceVersion()).append(",");
        }
        if (this.getProjectName() != null) {
            sb.append("ProjectName: ").append(this.getProjectName()).append(",");
        }
        if (this.getPhases() != null) {
            sb.append("Phases: ").append(this.getPhases()).append(",");
        }
        if (this.getSource() != null) {
            sb.append("Source: ").append(this.getSource()).append(",");
        }
        if (this.getSecondarySources() != null) {
            sb.append("SecondarySources: ").append(this.getSecondarySources()).append(",");
        }
        if (this.getSecondarySourceVersions() != null) {
            sb.append("SecondarySourceVersions: ").append(this.getSecondarySourceVersions()).append(",");
        }
        if (this.getArtifacts() != null) {
            sb.append("Artifacts: ").append(this.getArtifacts()).append(",");
        }
        if (this.getSecondaryArtifacts() != null) {
            sb.append("SecondaryArtifacts: ").append(this.getSecondaryArtifacts()).append(",");
        }
        if (this.getCache() != null) {
            sb.append("Cache: ").append(this.getCache()).append(",");
        }
        if (this.getEnvironment() != null) {
            sb.append("Environment: ").append(this.getEnvironment()).append(",");
        }
        if (this.getServiceRole() != null) {
            sb.append("ServiceRole: ").append(this.getServiceRole()).append(",");
        }
        if (this.getLogConfig() != null) {
            sb.append("LogConfig: ").append(this.getLogConfig()).append(",");
        }
        if (this.getBuildTimeoutInMinutes() != null) {
            sb.append("BuildTimeoutInMinutes: ").append(this.getBuildTimeoutInMinutes()).append(",");
        }
        if (this.getQueuedTimeoutInMinutes() != null) {
            sb.append("QueuedTimeoutInMinutes: ").append(this.getQueuedTimeoutInMinutes()).append(",");
        }
        if (this.getComplete() != null) {
            sb.append("Complete: ").append(this.getComplete()).append(",");
        }
        if (this.getInitiator() != null) {
            sb.append("Initiator: ").append(this.getInitiator()).append(",");
        }
        if (this.getVpcConfig() != null) {
            sb.append("VpcConfig: ").append(this.getVpcConfig()).append(",");
        }
        if (this.getEncryptionKey() != null) {
            sb.append("EncryptionKey: ").append(this.getEncryptionKey()).append(",");
        }
        if (this.getBuildBatchNumber() != null) {
            sb.append("BuildBatchNumber: ").append(this.getBuildBatchNumber()).append(",");
        }
        if (this.getFileSystemLocations() != null) {
            sb.append("FileSystemLocations: ").append(this.getFileSystemLocations()).append(",");
        }
        if (this.getBuildBatchConfig() != null) {
            sb.append("BuildBatchConfig: ").append(this.getBuildBatchConfig()).append(",");
        }
        if (this.getBuildGroups() != null) {
            sb.append("BuildGroups: ").append(this.getBuildGroups());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BuildBatch)) {
            return false;
        }
        BuildBatch other = (BuildBatch)obj;
        if (other.getId() == null ^ this.getId() == null) {
            return false;
        }
        if (other.getId() != null && !other.getId().equals(this.getId())) {
            return false;
        }
        if (other.getArn() == null ^ this.getArn() == null) {
            return false;
        }
        if (other.getArn() != null && !other.getArn().equals(this.getArn())) {
            return false;
        }
        if (other.getStartTime() == null ^ this.getStartTime() == null) {
            return false;
        }
        if (other.getStartTime() != null && !other.getStartTime().equals(this.getStartTime())) {
            return false;
        }
        if (other.getEndTime() == null ^ this.getEndTime() == null) {
            return false;
        }
        if (other.getEndTime() != null && !other.getEndTime().equals(this.getEndTime())) {
            return false;
        }
        if (other.getCurrentPhase() == null ^ this.getCurrentPhase() == null) {
            return false;
        }
        if (other.getCurrentPhase() != null && !other.getCurrentPhase().equals(this.getCurrentPhase())) {
            return false;
        }
        if (other.getBuildBatchStatus() == null ^ this.getBuildBatchStatus() == null) {
            return false;
        }
        if (other.getBuildBatchStatus() != null && !other.getBuildBatchStatus().equals(this.getBuildBatchStatus())) {
            return false;
        }
        if (other.getSourceVersion() == null ^ this.getSourceVersion() == null) {
            return false;
        }
        if (other.getSourceVersion() != null && !other.getSourceVersion().equals(this.getSourceVersion())) {
            return false;
        }
        if (other.getResolvedSourceVersion() == null ^ this.getResolvedSourceVersion() == null) {
            return false;
        }
        if (other.getResolvedSourceVersion() != null && !other.getResolvedSourceVersion().equals(this.getResolvedSourceVersion())) {
            return false;
        }
        if (other.getProjectName() == null ^ this.getProjectName() == null) {
            return false;
        }
        if (other.getProjectName() != null && !other.getProjectName().equals(this.getProjectName())) {
            return false;
        }
        if (other.getPhases() == null ^ this.getPhases() == null) {
            return false;
        }
        if (other.getPhases() != null && !other.getPhases().equals(this.getPhases())) {
            return false;
        }
        if (other.getSource() == null ^ this.getSource() == null) {
            return false;
        }
        if (other.getSource() != null && !other.getSource().equals(this.getSource())) {
            return false;
        }
        if (other.getSecondarySources() == null ^ this.getSecondarySources() == null) {
            return false;
        }
        if (other.getSecondarySources() != null && !other.getSecondarySources().equals(this.getSecondarySources())) {
            return false;
        }
        if (other.getSecondarySourceVersions() == null ^ this.getSecondarySourceVersions() == null) {
            return false;
        }
        if (other.getSecondarySourceVersions() != null && !other.getSecondarySourceVersions().equals(this.getSecondarySourceVersions())) {
            return false;
        }
        if (other.getArtifacts() == null ^ this.getArtifacts() == null) {
            return false;
        }
        if (other.getArtifacts() != null && !other.getArtifacts().equals(this.getArtifacts())) {
            return false;
        }
        if (other.getSecondaryArtifacts() == null ^ this.getSecondaryArtifacts() == null) {
            return false;
        }
        if (other.getSecondaryArtifacts() != null && !other.getSecondaryArtifacts().equals(this.getSecondaryArtifacts())) {
            return false;
        }
        if (other.getCache() == null ^ this.getCache() == null) {
            return false;
        }
        if (other.getCache() != null && !other.getCache().equals(this.getCache())) {
            return false;
        }
        if (other.getEnvironment() == null ^ this.getEnvironment() == null) {
            return false;
        }
        if (other.getEnvironment() != null && !other.getEnvironment().equals(this.getEnvironment())) {
            return false;
        }
        if (other.getServiceRole() == null ^ this.getServiceRole() == null) {
            return false;
        }
        if (other.getServiceRole() != null && !other.getServiceRole().equals(this.getServiceRole())) {
            return false;
        }
        if (other.getLogConfig() == null ^ this.getLogConfig() == null) {
            return false;
        }
        if (other.getLogConfig() != null && !other.getLogConfig().equals(this.getLogConfig())) {
            return false;
        }
        if (other.getBuildTimeoutInMinutes() == null ^ this.getBuildTimeoutInMinutes() == null) {
            return false;
        }
        if (other.getBuildTimeoutInMinutes() != null && !other.getBuildTimeoutInMinutes().equals(this.getBuildTimeoutInMinutes())) {
            return false;
        }
        if (other.getQueuedTimeoutInMinutes() == null ^ this.getQueuedTimeoutInMinutes() == null) {
            return false;
        }
        if (other.getQueuedTimeoutInMinutes() != null && !other.getQueuedTimeoutInMinutes().equals(this.getQueuedTimeoutInMinutes())) {
            return false;
        }
        if (other.getComplete() == null ^ this.getComplete() == null) {
            return false;
        }
        if (other.getComplete() != null && !other.getComplete().equals(this.getComplete())) {
            return false;
        }
        if (other.getInitiator() == null ^ this.getInitiator() == null) {
            return false;
        }
        if (other.getInitiator() != null && !other.getInitiator().equals(this.getInitiator())) {
            return false;
        }
        if (other.getVpcConfig() == null ^ this.getVpcConfig() == null) {
            return false;
        }
        if (other.getVpcConfig() != null && !other.getVpcConfig().equals(this.getVpcConfig())) {
            return false;
        }
        if (other.getEncryptionKey() == null ^ this.getEncryptionKey() == null) {
            return false;
        }
        if (other.getEncryptionKey() != null && !other.getEncryptionKey().equals(this.getEncryptionKey())) {
            return false;
        }
        if (other.getBuildBatchNumber() == null ^ this.getBuildBatchNumber() == null) {
            return false;
        }
        if (other.getBuildBatchNumber() != null && !other.getBuildBatchNumber().equals(this.getBuildBatchNumber())) {
            return false;
        }
        if (other.getFileSystemLocations() == null ^ this.getFileSystemLocations() == null) {
            return false;
        }
        if (other.getFileSystemLocations() != null && !other.getFileSystemLocations().equals(this.getFileSystemLocations())) {
            return false;
        }
        if (other.getBuildBatchConfig() == null ^ this.getBuildBatchConfig() == null) {
            return false;
        }
        if (other.getBuildBatchConfig() != null && !other.getBuildBatchConfig().equals(this.getBuildBatchConfig())) {
            return false;
        }
        if (other.getBuildGroups() == null ^ this.getBuildGroups() == null) {
            return false;
        }
        return other.getBuildGroups() == null || other.getBuildGroups().equals(this.getBuildGroups());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getId() == null ? 0 : this.getId().hashCode());
        hashCode = 31 * hashCode + (this.getArn() == null ? 0 : this.getArn().hashCode());
        hashCode = 31 * hashCode + (this.getStartTime() == null ? 0 : this.getStartTime().hashCode());
        hashCode = 31 * hashCode + (this.getEndTime() == null ? 0 : this.getEndTime().hashCode());
        hashCode = 31 * hashCode + (this.getCurrentPhase() == null ? 0 : this.getCurrentPhase().hashCode());
        hashCode = 31 * hashCode + (this.getBuildBatchStatus() == null ? 0 : this.getBuildBatchStatus().hashCode());
        hashCode = 31 * hashCode + (this.getSourceVersion() == null ? 0 : this.getSourceVersion().hashCode());
        hashCode = 31 * hashCode + (this.getResolvedSourceVersion() == null ? 0 : this.getResolvedSourceVersion().hashCode());
        hashCode = 31 * hashCode + (this.getProjectName() == null ? 0 : this.getProjectName().hashCode());
        hashCode = 31 * hashCode + (this.getPhases() == null ? 0 : this.getPhases().hashCode());
        hashCode = 31 * hashCode + (this.getSource() == null ? 0 : this.getSource().hashCode());
        hashCode = 31 * hashCode + (this.getSecondarySources() == null ? 0 : this.getSecondarySources().hashCode());
        hashCode = 31 * hashCode + (this.getSecondarySourceVersions() == null ? 0 : this.getSecondarySourceVersions().hashCode());
        hashCode = 31 * hashCode + (this.getArtifacts() == null ? 0 : this.getArtifacts().hashCode());
        hashCode = 31 * hashCode + (this.getSecondaryArtifacts() == null ? 0 : this.getSecondaryArtifacts().hashCode());
        hashCode = 31 * hashCode + (this.getCache() == null ? 0 : this.getCache().hashCode());
        hashCode = 31 * hashCode + (this.getEnvironment() == null ? 0 : this.getEnvironment().hashCode());
        hashCode = 31 * hashCode + (this.getServiceRole() == null ? 0 : this.getServiceRole().hashCode());
        hashCode = 31 * hashCode + (this.getLogConfig() == null ? 0 : this.getLogConfig().hashCode());
        hashCode = 31 * hashCode + (this.getBuildTimeoutInMinutes() == null ? 0 : this.getBuildTimeoutInMinutes().hashCode());
        hashCode = 31 * hashCode + (this.getQueuedTimeoutInMinutes() == null ? 0 : this.getQueuedTimeoutInMinutes().hashCode());
        hashCode = 31 * hashCode + (this.getComplete() == null ? 0 : this.getComplete().hashCode());
        hashCode = 31 * hashCode + (this.getInitiator() == null ? 0 : this.getInitiator().hashCode());
        hashCode = 31 * hashCode + (this.getVpcConfig() == null ? 0 : this.getVpcConfig().hashCode());
        hashCode = 31 * hashCode + (this.getEncryptionKey() == null ? 0 : this.getEncryptionKey().hashCode());
        hashCode = 31 * hashCode + (this.getBuildBatchNumber() == null ? 0 : this.getBuildBatchNumber().hashCode());
        hashCode = 31 * hashCode + (this.getFileSystemLocations() == null ? 0 : this.getFileSystemLocations().hashCode());
        hashCode = 31 * hashCode + (this.getBuildBatchConfig() == null ? 0 : this.getBuildBatchConfig().hashCode());
        hashCode = 31 * hashCode + (this.getBuildGroups() == null ? 0 : this.getBuildGroups().hashCode());
        return hashCode;
    }

    public BuildBatch clone() {
        try {
            return (BuildBatch)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BuildBatchMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

