/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codebuild;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.codebuild.AWSCodeBuild;
import com.amazonaws.services.codebuild.AWSCodeBuildClientBuilder;
import com.amazonaws.services.codebuild.model.AWSCodeBuildException;
import com.amazonaws.services.codebuild.model.AccountLimitExceededException;
import com.amazonaws.services.codebuild.model.BatchDeleteBuildsRequest;
import com.amazonaws.services.codebuild.model.BatchDeleteBuildsResult;
import com.amazonaws.services.codebuild.model.BatchGetBuildsRequest;
import com.amazonaws.services.codebuild.model.BatchGetBuildsResult;
import com.amazonaws.services.codebuild.model.BatchGetProjectsRequest;
import com.amazonaws.services.codebuild.model.BatchGetProjectsResult;
import com.amazonaws.services.codebuild.model.CreateProjectRequest;
import com.amazonaws.services.codebuild.model.CreateProjectResult;
import com.amazonaws.services.codebuild.model.CreateWebhookRequest;
import com.amazonaws.services.codebuild.model.CreateWebhookResult;
import com.amazonaws.services.codebuild.model.DeleteProjectRequest;
import com.amazonaws.services.codebuild.model.DeleteProjectResult;
import com.amazonaws.services.codebuild.model.DeleteWebhookRequest;
import com.amazonaws.services.codebuild.model.DeleteWebhookResult;
import com.amazonaws.services.codebuild.model.InvalidInputException;
import com.amazonaws.services.codebuild.model.InvalidateProjectCacheRequest;
import com.amazonaws.services.codebuild.model.InvalidateProjectCacheResult;
import com.amazonaws.services.codebuild.model.ListBuildsForProjectRequest;
import com.amazonaws.services.codebuild.model.ListBuildsForProjectResult;
import com.amazonaws.services.codebuild.model.ListBuildsRequest;
import com.amazonaws.services.codebuild.model.ListBuildsResult;
import com.amazonaws.services.codebuild.model.ListCuratedEnvironmentImagesRequest;
import com.amazonaws.services.codebuild.model.ListCuratedEnvironmentImagesResult;
import com.amazonaws.services.codebuild.model.ListProjectsRequest;
import com.amazonaws.services.codebuild.model.ListProjectsResult;
import com.amazonaws.services.codebuild.model.OAuthProviderException;
import com.amazonaws.services.codebuild.model.ResourceAlreadyExistsException;
import com.amazonaws.services.codebuild.model.ResourceNotFoundException;
import com.amazonaws.services.codebuild.model.StartBuildRequest;
import com.amazonaws.services.codebuild.model.StartBuildResult;
import com.amazonaws.services.codebuild.model.StopBuildRequest;
import com.amazonaws.services.codebuild.model.StopBuildResult;
import com.amazonaws.services.codebuild.model.UpdateProjectRequest;
import com.amazonaws.services.codebuild.model.UpdateProjectResult;
import com.amazonaws.services.codebuild.model.transform.BatchDeleteBuildsRequestProtocolMarshaller;
import com.amazonaws.services.codebuild.model.transform.BatchDeleteBuildsResultJsonUnmarshaller;
import com.amazonaws.services.codebuild.model.transform.BatchGetBuildsRequestProtocolMarshaller;
import com.amazonaws.services.codebuild.model.transform.BatchGetBuildsResultJsonUnmarshaller;
import com.amazonaws.services.codebuild.model.transform.BatchGetProjectsRequestProtocolMarshaller;
import com.amazonaws.services.codebuild.model.transform.BatchGetProjectsResultJsonUnmarshaller;
import com.amazonaws.services.codebuild.model.transform.CreateProjectRequestProtocolMarshaller;
import com.amazonaws.services.codebuild.model.transform.CreateProjectResultJsonUnmarshaller;
import com.amazonaws.services.codebuild.model.transform.CreateWebhookRequestProtocolMarshaller;
import com.amazonaws.services.codebuild.model.transform.CreateWebhookResultJsonUnmarshaller;
import com.amazonaws.services.codebuild.model.transform.DeleteProjectRequestProtocolMarshaller;
import com.amazonaws.services.codebuild.model.transform.DeleteProjectResultJsonUnmarshaller;
import com.amazonaws.services.codebuild.model.transform.DeleteWebhookRequestProtocolMarshaller;
import com.amazonaws.services.codebuild.model.transform.DeleteWebhookResultJsonUnmarshaller;
import com.amazonaws.services.codebuild.model.transform.InvalidateProjectCacheRequestProtocolMarshaller;
import com.amazonaws.services.codebuild.model.transform.InvalidateProjectCacheResultJsonUnmarshaller;
import com.amazonaws.services.codebuild.model.transform.ListBuildsForProjectRequestProtocolMarshaller;
import com.amazonaws.services.codebuild.model.transform.ListBuildsForProjectResultJsonUnmarshaller;
import com.amazonaws.services.codebuild.model.transform.ListBuildsRequestProtocolMarshaller;
import com.amazonaws.services.codebuild.model.transform.ListBuildsResultJsonUnmarshaller;
import com.amazonaws.services.codebuild.model.transform.ListCuratedEnvironmentImagesRequestProtocolMarshaller;
import com.amazonaws.services.codebuild.model.transform.ListCuratedEnvironmentImagesResultJsonUnmarshaller;
import com.amazonaws.services.codebuild.model.transform.ListProjectsRequestProtocolMarshaller;
import com.amazonaws.services.codebuild.model.transform.ListProjectsResultJsonUnmarshaller;
import com.amazonaws.services.codebuild.model.transform.StartBuildRequestProtocolMarshaller;
import com.amazonaws.services.codebuild.model.transform.StartBuildResultJsonUnmarshaller;
import com.amazonaws.services.codebuild.model.transform.StopBuildRequestProtocolMarshaller;
import com.amazonaws.services.codebuild.model.transform.StopBuildResultJsonUnmarshaller;
import com.amazonaws.services.codebuild.model.transform.UpdateProjectRequestProtocolMarshaller;
import com.amazonaws.services.codebuild.model.transform.UpdateProjectResultJsonUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSCodeBuildClient
extends AmazonWebServiceClient
implements AWSCodeBuild {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSCodeBuild.class);
    private static final String DEFAULT_SIGNING_NAME = "codebuild";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withModeledClass(ResourceNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidInputException").withModeledClass(InvalidInputException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AccountLimitExceededException").withModeledClass(AccountLimitExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("OAuthProviderException").withModeledClass(OAuthProviderException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceAlreadyExistsException").withModeledClass(ResourceAlreadyExistsException.class)).withBaseServiceExceptionClass(AWSCodeBuildException.class));

    @Deprecated
    public AWSCodeBuildClient() {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), configFactory.getConfig());
    }

    @Deprecated
    public AWSCodeBuildClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration);
    }

    @Deprecated
    public AWSCodeBuildClient(AWSCredentials awsCredentials) {
        this(awsCredentials, configFactory.getConfig());
    }

    @Deprecated
    public AWSCodeBuildClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    @Deprecated
    public AWSCodeBuildClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, configFactory.getConfig());
    }

    @Deprecated
    public AWSCodeBuildClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, null);
    }

    @Deprecated
    public AWSCodeBuildClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(clientConfiguration, requestMetricCollector);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    public static AWSCodeBuildClientBuilder builder() {
        return AWSCodeBuildClientBuilder.standard();
    }

    AWSCodeBuildClient(AwsSyncClientParams clientParams) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("codebuild.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/codebuild/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/codebuild/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public BatchDeleteBuildsResult batchDeleteBuilds(BatchDeleteBuildsRequest request) {
        request = (BatchDeleteBuildsRequest)this.beforeClientExecution(request);
        return this.executeBatchDeleteBuilds(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final BatchDeleteBuildsResult executeBatchDeleteBuilds(BatchDeleteBuildsRequest batchDeleteBuildsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(batchDeleteBuildsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<BatchDeleteBuildsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new BatchDeleteBuildsRequestProtocolMarshaller(protocolFactory).marshall((BatchDeleteBuildsRequest)super.beforeMarshalling((AmazonWebServiceRequest)batchDeleteBuildsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new BatchDeleteBuildsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            BatchDeleteBuildsResult batchDeleteBuildsResult = (BatchDeleteBuildsResult)response.getAwsResponse();
            return batchDeleteBuildsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public BatchGetBuildsResult batchGetBuilds(BatchGetBuildsRequest request) {
        request = (BatchGetBuildsRequest)this.beforeClientExecution(request);
        return this.executeBatchGetBuilds(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final BatchGetBuildsResult executeBatchGetBuilds(BatchGetBuildsRequest batchGetBuildsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(batchGetBuildsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<BatchGetBuildsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new BatchGetBuildsRequestProtocolMarshaller(protocolFactory).marshall((BatchGetBuildsRequest)super.beforeMarshalling((AmazonWebServiceRequest)batchGetBuildsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new BatchGetBuildsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            BatchGetBuildsResult batchGetBuildsResult = (BatchGetBuildsResult)response.getAwsResponse();
            return batchGetBuildsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public BatchGetProjectsResult batchGetProjects(BatchGetProjectsRequest request) {
        request = (BatchGetProjectsRequest)this.beforeClientExecution(request);
        return this.executeBatchGetProjects(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final BatchGetProjectsResult executeBatchGetProjects(BatchGetProjectsRequest batchGetProjectsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(batchGetProjectsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<BatchGetProjectsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new BatchGetProjectsRequestProtocolMarshaller(protocolFactory).marshall((BatchGetProjectsRequest)super.beforeMarshalling((AmazonWebServiceRequest)batchGetProjectsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new BatchGetProjectsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            BatchGetProjectsResult batchGetProjectsResult = (BatchGetProjectsResult)response.getAwsResponse();
            return batchGetProjectsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateProjectResult createProject(CreateProjectRequest request) {
        request = (CreateProjectRequest)this.beforeClientExecution(request);
        return this.executeCreateProject(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateProjectResult executeCreateProject(CreateProjectRequest createProjectRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createProjectRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateProjectRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateProjectRequestProtocolMarshaller(protocolFactory).marshall((CreateProjectRequest)super.beforeMarshalling((AmazonWebServiceRequest)createProjectRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateProjectResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateProjectResult createProjectResult = (CreateProjectResult)response.getAwsResponse();
            return createProjectResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateWebhookResult createWebhook(CreateWebhookRequest request) {
        request = (CreateWebhookRequest)this.beforeClientExecution(request);
        return this.executeCreateWebhook(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateWebhookResult executeCreateWebhook(CreateWebhookRequest createWebhookRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createWebhookRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateWebhookRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateWebhookRequestProtocolMarshaller(protocolFactory).marshall((CreateWebhookRequest)super.beforeMarshalling((AmazonWebServiceRequest)createWebhookRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateWebhookResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateWebhookResult createWebhookResult = (CreateWebhookResult)response.getAwsResponse();
            return createWebhookResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteProjectResult deleteProject(DeleteProjectRequest request) {
        request = (DeleteProjectRequest)this.beforeClientExecution(request);
        return this.executeDeleteProject(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteProjectResult executeDeleteProject(DeleteProjectRequest deleteProjectRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteProjectRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteProjectRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteProjectRequestProtocolMarshaller(protocolFactory).marshall((DeleteProjectRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteProjectRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteProjectResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteProjectResult deleteProjectResult = (DeleteProjectResult)response.getAwsResponse();
            return deleteProjectResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteWebhookResult deleteWebhook(DeleteWebhookRequest request) {
        request = (DeleteWebhookRequest)this.beforeClientExecution(request);
        return this.executeDeleteWebhook(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteWebhookResult executeDeleteWebhook(DeleteWebhookRequest deleteWebhookRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteWebhookRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteWebhookRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteWebhookRequestProtocolMarshaller(protocolFactory).marshall((DeleteWebhookRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteWebhookRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteWebhookResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteWebhookResult deleteWebhookResult = (DeleteWebhookResult)response.getAwsResponse();
            return deleteWebhookResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public InvalidateProjectCacheResult invalidateProjectCache(InvalidateProjectCacheRequest request) {
        request = (InvalidateProjectCacheRequest)this.beforeClientExecution(request);
        return this.executeInvalidateProjectCache(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final InvalidateProjectCacheResult executeInvalidateProjectCache(InvalidateProjectCacheRequest invalidateProjectCacheRequest) {
        ExecutionContext executionContext = this.createExecutionContext(invalidateProjectCacheRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<InvalidateProjectCacheRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new InvalidateProjectCacheRequestProtocolMarshaller(protocolFactory).marshall((InvalidateProjectCacheRequest)super.beforeMarshalling((AmazonWebServiceRequest)invalidateProjectCacheRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new InvalidateProjectCacheResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            InvalidateProjectCacheResult invalidateProjectCacheResult = (InvalidateProjectCacheResult)response.getAwsResponse();
            return invalidateProjectCacheResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListBuildsResult listBuilds(ListBuildsRequest request) {
        request = (ListBuildsRequest)this.beforeClientExecution(request);
        return this.executeListBuilds(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListBuildsResult executeListBuilds(ListBuildsRequest listBuildsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listBuildsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListBuildsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListBuildsRequestProtocolMarshaller(protocolFactory).marshall((ListBuildsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listBuildsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListBuildsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListBuildsResult listBuildsResult = (ListBuildsResult)response.getAwsResponse();
            return listBuildsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListBuildsForProjectResult listBuildsForProject(ListBuildsForProjectRequest request) {
        request = (ListBuildsForProjectRequest)this.beforeClientExecution(request);
        return this.executeListBuildsForProject(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListBuildsForProjectResult executeListBuildsForProject(ListBuildsForProjectRequest listBuildsForProjectRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listBuildsForProjectRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListBuildsForProjectRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListBuildsForProjectRequestProtocolMarshaller(protocolFactory).marshall((ListBuildsForProjectRequest)super.beforeMarshalling((AmazonWebServiceRequest)listBuildsForProjectRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListBuildsForProjectResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListBuildsForProjectResult listBuildsForProjectResult = (ListBuildsForProjectResult)response.getAwsResponse();
            return listBuildsForProjectResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListCuratedEnvironmentImagesResult listCuratedEnvironmentImages(ListCuratedEnvironmentImagesRequest request) {
        request = (ListCuratedEnvironmentImagesRequest)this.beforeClientExecution(request);
        return this.executeListCuratedEnvironmentImages(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListCuratedEnvironmentImagesResult executeListCuratedEnvironmentImages(ListCuratedEnvironmentImagesRequest listCuratedEnvironmentImagesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listCuratedEnvironmentImagesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListCuratedEnvironmentImagesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListCuratedEnvironmentImagesRequestProtocolMarshaller(protocolFactory).marshall((ListCuratedEnvironmentImagesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listCuratedEnvironmentImagesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListCuratedEnvironmentImagesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListCuratedEnvironmentImagesResult listCuratedEnvironmentImagesResult = (ListCuratedEnvironmentImagesResult)response.getAwsResponse();
            return listCuratedEnvironmentImagesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListProjectsResult listProjects(ListProjectsRequest request) {
        request = (ListProjectsRequest)this.beforeClientExecution(request);
        return this.executeListProjects(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListProjectsResult executeListProjects(ListProjectsRequest listProjectsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listProjectsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListProjectsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListProjectsRequestProtocolMarshaller(protocolFactory).marshall((ListProjectsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listProjectsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListProjectsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListProjectsResult listProjectsResult = (ListProjectsResult)response.getAwsResponse();
            return listProjectsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StartBuildResult startBuild(StartBuildRequest request) {
        request = (StartBuildRequest)this.beforeClientExecution(request);
        return this.executeStartBuild(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StartBuildResult executeStartBuild(StartBuildRequest startBuildRequest) {
        ExecutionContext executionContext = this.createExecutionContext(startBuildRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StartBuildRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StartBuildRequestProtocolMarshaller(protocolFactory).marshall((StartBuildRequest)super.beforeMarshalling((AmazonWebServiceRequest)startBuildRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StartBuildResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StartBuildResult startBuildResult = (StartBuildResult)response.getAwsResponse();
            return startBuildResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StopBuildResult stopBuild(StopBuildRequest request) {
        request = (StopBuildRequest)this.beforeClientExecution(request);
        return this.executeStopBuild(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StopBuildResult executeStopBuild(StopBuildRequest stopBuildRequest) {
        ExecutionContext executionContext = this.createExecutionContext(stopBuildRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StopBuildRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StopBuildRequestProtocolMarshaller(protocolFactory).marshall((StopBuildRequest)super.beforeMarshalling((AmazonWebServiceRequest)stopBuildRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StopBuildResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StopBuildResult stopBuildResult = (StopBuildResult)response.getAwsResponse();
            return stopBuildResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateProjectResult updateProject(UpdateProjectRequest request) {
        request = (UpdateProjectRequest)this.beforeClientExecution(request);
        return this.executeUpdateProject(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateProjectResult executeUpdateProject(UpdateProjectRequest updateProjectRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateProjectRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateProjectRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateProjectRequestProtocolMarshaller(protocolFactory).marshall((UpdateProjectRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateProjectRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateProjectResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateProjectResult updateProjectResult = (UpdateProjectResult)response.getAwsResponse();
            return updateProjectResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }
}

