/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.codegen.utils;

import com.amazonaws.codegen.internal.Jackson;
import com.amazonaws.codegen.internal.Utils;
import com.amazonaws.codegen.model.service.ServiceModel;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;

public class ModelLoaderUtils {
    public static ServiceModel loadModel(String modelLocation) {
        return ModelLoaderUtils.loadConfigurationModel(ServiceModel.class, modelLocation);
    }

    public static <T> T loadConfigurationModel(Class<T> clzz, String configurationFileLocation) {
        System.out.println("Loading config file " + configurationFileLocation);
        InputStream fileContents = null;
        try {
            fileContents = ModelLoaderUtils.getRequiredResourceAsStream(configurationFileLocation);
            T t = Jackson.load(clzz, fileContents);
            return t;
        }
        catch (IOException e) {
            System.err.println("Failed to read the configuration file " + configurationFileLocation);
            throw new RuntimeException(e);
        }
        finally {
            if (fileContents != null) {
                Utils.closeQuietly(fileContents);
            }
        }
    }

    public static InputStream getRequiredResourceAsStream(String location) {
        return Utils.getRequiredResourceAsStream(ModelLoaderUtils.class, location);
    }

    public static <T> T loadModel(Class<T> clzz, File file) {
        try {
            return Jackson.load(clzz, file);
        }
        catch (IOException e) {
            System.err.println("Failed to read the configuration file " + file.getAbsolutePath());
            throw new RuntimeException(e);
        }
    }

    public static <T> Optional<T> loadOptionalModel(Class<T> clzz, File file) {
        if (!file.exists()) {
            return Optional.empty();
        }
        return Optional.of(ModelLoaderUtils.loadModel(clzz, file));
    }
}

