/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.codegen.model.intermediate;

import com.amazonaws.codegen.internal.Constants;
import com.amazonaws.codegen.internal.DocumentationUtils;
import com.amazonaws.codegen.internal.TypeUtils;
import com.amazonaws.codegen.model.intermediate.DocumentationModel;
import com.amazonaws.codegen.model.intermediate.ListModel;
import com.amazonaws.codegen.model.intermediate.MapModel;
import com.amazonaws.codegen.model.intermediate.ParameterHttpMapping;
import com.amazonaws.codegen.model.intermediate.ReturnTypeModel;
import com.amazonaws.codegen.model.intermediate.ShapeModel;
import com.amazonaws.codegen.model.intermediate.VariableModel;
import com.amazonaws.transform.PathMarshallers;
import com.fasterxml.jackson.annotation.JsonIgnore;

public class MemberModel
extends DocumentationModel {
    private String name;
    private String c2jName;
    private String c2jShape;
    private VariableModel variable;
    private VariableModel setterModel;
    private String getterMethodName;
    private String setterMethodName;
    private String fluentSetterMethodName;
    private ReturnTypeModel getterModel;
    private ParameterHttpMapping http;
    private boolean deprecated;
    private boolean endpointDiscoveryId;
    private boolean sensitive;
    private ListModel listModel;
    private MapModel mapModel;
    private String enumType;
    private String xmlNameSpaceUri;
    private boolean idempotencyToken;
    private ShapeModel shape;
    private boolean isJsonValue;
    private boolean shouldEmitLegacyEnumSetter;
    private boolean shouldFullyQualify = false;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public MemberModel withName(String name) {
        this.setName(name);
        return this;
    }

    public String getC2jName() {
        return this.c2jName;
    }

    public void setC2jName(String c2jName) {
        this.c2jName = c2jName;
    }

    public MemberModel withC2jName(String c2jName) {
        this.setC2jName(c2jName);
        return this;
    }

    public String getC2jShape() {
        return this.c2jShape;
    }

    public void setC2jShape(String c2jShape) {
        this.c2jShape = c2jShape;
    }

    public MemberModel withC2jShape(String c2jShape) {
        this.setC2jShape(c2jShape);
        return this;
    }

    public VariableModel getVariable() {
        return this.variable;
    }

    public void setVariable(VariableModel variable) {
        this.variable = variable;
    }

    public MemberModel withVariable(VariableModel variable) {
        this.setVariable(variable);
        return this;
    }

    public VariableModel getSetterModel() {
        return this.setterModel;
    }

    public void setSetterModel(VariableModel setterModel) {
        this.setterModel = setterModel;
    }

    public MemberModel withSetterModel(VariableModel setterModel) {
        this.setSetterModel(setterModel);
        return this;
    }

    public String getGetterMethodName() {
        return this.getterMethodName;
    }

    public void setGetterMethodName(String getterMethodName) {
        this.getterMethodName = getterMethodName;
    }

    public MemberModel withGetterMethodName(String getterMethodName) {
        this.setGetterMethodName(getterMethodName);
        return this;
    }

    public String getSetterMethodName() {
        return this.setterMethodName;
    }

    public void setSetterMethodName(String setterMethodName) {
        this.setterMethodName = setterMethodName;
    }

    public MemberModel withSetterMethodName(String setterMethodName) {
        this.setSetterMethodName(setterMethodName);
        return this;
    }

    public String getFluentSetterMethodName() {
        return this.fluentSetterMethodName;
    }

    public void setFluentSetterMethodName(String fluentSetterMethodName) {
        this.fluentSetterMethodName = fluentSetterMethodName;
    }

    public MemberModel withFluentSetterMethodName(String fluentMethodName) {
        this.setFluentSetterMethodName(fluentMethodName);
        return this;
    }

    public ReturnTypeModel getGetterModel() {
        return this.getterModel;
    }

    public void setGetterModel(ReturnTypeModel getterModel) {
        this.getterModel = getterModel;
    }

    public MemberModel withGetterModel(ReturnTypeModel getterModel) {
        this.setGetterModel(getterModel);
        return this;
    }

    public ParameterHttpMapping getHttp() {
        return this.http;
    }

    public void setHttp(ParameterHttpMapping parameterHttpMapping) {
        this.http = parameterHttpMapping;
    }

    public boolean isSimple() {
        return TypeUtils.isSimple(this.variable.getVariableType());
    }

    public boolean isList() {
        return this.listModel != null;
    }

    public boolean isMap() {
        return this.mapModel != null;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public void setDeprecated(boolean deprecated) {
        this.deprecated = deprecated;
    }

    public boolean isSensitive() {
        return this.sensitive;
    }

    public void setSensitive(boolean sensitive) {
        this.sensitive = sensitive;
    }

    public boolean isEndpointDiscoveryId() {
        return this.endpointDiscoveryId;
    }

    public void setEndpointDiscoveryId(boolean endpointDiscoveryId) {
        this.endpointDiscoveryId = endpointDiscoveryId;
    }

    public ListModel getListModel() {
        return this.listModel;
    }

    public void setListModel(ListModel listModel) {
        this.listModel = listModel;
    }

    public MapModel getMapModel() {
        return this.mapModel;
    }

    public MemberModel withListModel(ListModel list) {
        this.setListModel(list);
        return this;
    }

    public void setMapModel(MapModel map) {
        this.mapModel = map;
    }

    public MemberModel withMapModel(MapModel map) {
        this.setMapModel(map);
        return this;
    }

    public String getEnumType() {
        return this.enumType;
    }

    public void setEnumType(String enumType) {
        this.enumType = enumType;
    }

    public MemberModel withEnumType(String enumType) {
        this.setEnumType(enumType);
        return this;
    }

    public String getXmlNameSpaceUri() {
        return this.xmlNameSpaceUri;
    }

    public void setXmlNameSpaceUri(String xmlNameSpaceUri) {
        this.xmlNameSpaceUri = xmlNameSpaceUri;
    }

    public MemberModel withXmlNameSpaceUri(String xmlNameSpaceUri) {
        this.setXmlNameSpaceUri(xmlNameSpaceUri);
        return this;
    }

    public String getSetterDocumentation() {
        StringBuilder docBuilder = new StringBuilder("/**");
        docBuilder.append(this.getSetterDoc()).append(this.getSetterGuidanceDoc()).append(this.getParamDoc()).append(this.getEnumDoc()).append("*/");
        return docBuilder.toString();
    }

    public String getGetterDocumentation() {
        StringBuilder docBuilder = new StringBuilder("/**");
        docBuilder.append(this.documentation != null ? this.documentation : "Returns the value of the %s property for this object.".replace("%s", this.name)).append(Constants.LINE_SEPARATOR);
        if (this.isJsonValue()) {
            docBuilder.append("<p>").append(Constants.LINE_SEPARATOR).append("This field's value will be valid JSON according to RFC 7159, including the opening and closing ").append("braces. For example: '{\"key\": \"value\"}'.").append(Constants.LINE_SEPARATOR).append("</p>").append(Constants.LINE_SEPARATOR);
        }
        if ("java.nio.ByteBuffer".equals(this.getGetterModel().getReturnType())) {
            docBuilder.append("<p>").append(Constants.LINE_SEPARATOR).append("{@code ByteBuffer}s are stateful. Calling their {@code get} methods changes their {@code position}. We recommend using {@link java.nio.ByteBuffer#asReadOnlyBuffer()} to create a read-only view of the buffer with an independent {@code position}, and calling {@code get} methods on this rather than directly on the returned {@code ByteBuffer}. Doing so will ensure that anyone else using the {@code ByteBuffer} will not be affected by changes to the {@code position}.").append(Constants.LINE_SEPARATOR).append("</p>").append(Constants.LINE_SEPARATOR);
        }
        String variableDesc = this.documentation != null ? this.documentation : "The value of the %s property for this object.".replace("%s", this.name);
        docBuilder.append("@return " + DocumentationUtils.stripHTMLTags(variableDesc)).append(this.getEnumDoc()).append("*/");
        return docBuilder.toString();
    }

    public String getFluentSetterDocumentation() {
        StringBuilder docBuilder = new StringBuilder("/**");
        docBuilder.append(this.getSetterDoc()).append(this.getSetterGuidanceDoc()).append(this.getParamDoc()).append(Constants.LINE_SEPARATOR).append("@return " + DocumentationUtils.stripHTMLTags("Returns a reference to this object so that method calls can be chained together.")).append(this.getEnumDoc()).append("*/");
        return docBuilder.toString();
    }

    public String getVarargSetterDocumentation() {
        StringBuilder docBuilder = new StringBuilder("/**");
        docBuilder.append(this.getSetterDoc());
        if (this.listModel != null) {
            docBuilder.append(Constants.LINE_SEPARATOR).append("<p><b>NOTE:</b> This method appends the values to the existing list (if any). Use {@link #set%s(java.util.Collection)} or {@link #with%s(java.util.Collection)} if you want to override the existing values.</p>".replaceAll("%s", this.name));
        }
        docBuilder.append(this.getParamDoc()).append(Constants.LINE_SEPARATOR).append("@return " + DocumentationUtils.stripHTMLTags("Returns a reference to this object so that method calls can be chained together.")).append(this.getEnumDoc());
        docBuilder.append("*/");
        return docBuilder.toString();
    }

    private String getSetterDoc() {
        return this.documentation != null ? this.documentation : "Sets the value of the %s property for this object.".replace("%s", this.name);
    }

    private String getSetterGuidanceDoc() {
        boolean isByteBuffer;
        StringBuilder docBuilder = new StringBuilder();
        if (this.isJsonValue()) {
            docBuilder.append("<p>").append(Constants.LINE_SEPARATOR).append("This field's value must be valid JSON according to RFC 7159, including the opening and closing ").append("braces. For example: '{\"key\": \"value\"}'.").append(Constants.LINE_SEPARATOR).append("</p>").append(Constants.LINE_SEPARATOR);
        }
        if ((isByteBuffer = "java.nio.ByteBuffer".equals(this.getGetterModel().getReturnType())) || this.isJsonValue()) {
            docBuilder.append("<p>").append(Constants.LINE_SEPARATOR).append("The AWS SDK for Java performs a Base64 encoding on this field before sending this request to the ").append("AWS service. Users of the SDK should not perform Base64 encoding on this field.").append(Constants.LINE_SEPARATOR).append("</p>").append(Constants.LINE_SEPARATOR);
        }
        if (isByteBuffer) {
            docBuilder.append("<p>").append(Constants.LINE_SEPARATOR).append("Warning: ByteBuffers returned by the SDK are mutable. Changes to the content or position of the byte buffer will be seen by all objects that have a reference to this object. It is recommended to call ByteBuffer.duplicate() or ByteBuffer.asReadOnlyBuffer() before using or reading from the buffer. This behavior will be changed in a future major version of the SDK.").append(Constants.LINE_SEPARATOR).append("</p>").append(Constants.LINE_SEPARATOR);
        }
        return docBuilder.toString();
    }

    private String getParamDoc() {
        StringBuilder docBuilder = new StringBuilder();
        String variableDesc = this.documentation != null ? this.documentation : "The new value for the %s property for this object.".replace("%s", this.name);
        docBuilder.append(Constants.LINE_SEPARATOR).append("@param " + this.variable.getVariableName() + " " + DocumentationUtils.stripHTMLTags(variableDesc));
        return docBuilder.toString();
    }

    private String getEnumDoc() {
        StringBuilder docBuilder = new StringBuilder();
        if (this.enumType != null) {
            docBuilder.append(Constants.LINE_SEPARATOR);
            docBuilder.append("@see " + this.enumType);
        }
        return docBuilder.toString();
    }

    public boolean isIdempotencyToken() {
        return this.idempotencyToken;
    }

    public void setIdempotencyToken(boolean idempotencyToken) {
        this.idempotencyToken = idempotencyToken;
    }

    public boolean isJsonValue() {
        return this.isJsonValue;
    }

    public void setJsonValue(boolean isJsonValue) {
        this.isJsonValue = isJsonValue;
    }

    public boolean getIsBinary() {
        return this.http.getIsStreaming() || this.http.getIsPayload() && "java.nio.ByteBuffer".equals(this.variable.getVariableType());
    }

    @JsonIgnore
    public String getPathMarshaller() {
        if (!this.http.isUri()) {
            throw new IllegalStateException("Only members bound to the URI have a path marshaller");
        }
        String prefix = PathMarshallers.class.getName();
        if (this.http.isGreedy()) {
            return prefix + ".GREEDY";
        }
        if (this.isIdempotencyToken()) {
            return prefix + ".IDEMPOTENCY";
        }
        return prefix + ".NON_GREEDY";
    }

    @JsonIgnore
    public String getMarshallerBindingFieldName() {
        return this.name.toUpperCase() + "_BINDING";
    }

    public String getMarshallingType() {
        if (this.isList()) {
            return "LIST";
        }
        if (this.isMap()) {
            return "MAP";
        }
        if (this.isJsonValue()) {
            return "JSON_VALUE";
        }
        if (!this.isSimple()) {
            return "STRUCTURED";
        }
        return TypeUtils.getMarshallingType(this.variable.getSimpleType());
    }

    public String getUnmarshallingType() {
        if (this.isJsonValue()) {
            return "JSON_VALUE";
        }
        return null;
    }

    public String getMarshallingTargetClass() {
        if (this.isList()) {
            return "List";
        }
        if (this.isMap()) {
            return "Map";
        }
        if (!this.isSimple()) {
            return "StructuredPojo";
        }
        return this.variable.getVariableType();
    }

    @JsonIgnore
    public ShapeModel getShape() {
        return this.shape;
    }

    public void setShape(ShapeModel shape) {
        this.shape = shape;
    }

    public boolean getShouldEmitLegacyEnumSetter() {
        return this.shouldEmitLegacyEnumSetter;
    }

    public void setShouldEmitLegacyEnumSetter(boolean shouldEmitLegacyEnumSetter) {
        this.shouldEmitLegacyEnumSetter = shouldEmitLegacyEnumSetter;
    }

    public void setShouldFullyQualify(boolean shouldFullyQualify) {
        this.shouldFullyQualify = shouldFullyQualify;
    }

    public boolean getShouldFullyQualify() {
        return this.shouldFullyQualify;
    }

    public String toString() {
        return this.c2jName;
    }
}

