/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.codegen.model.service;

import com.amazonaws.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class HostPrefixProcessor {
    private static final String CURLY_BRACES_PATTERN = "\\{([^}]+)}";
    private static final Pattern PATTERN = Pattern.compile("\\{([^}]+)}");
    private String hostWithStringSpecifier;
    private List<String> c2jNames;

    public HostPrefixProcessor(String hostExpression) {
        this.hostWithStringSpecifier = hostExpression;
        this.c2jNames = new ArrayList<String>();
        this.replaceHostLabelsWithStringSpecifier(hostExpression);
    }

    private void replaceHostLabelsWithStringSpecifier(String hostExpression) {
        if (StringUtils.isNullOrEmpty((String)hostExpression)) {
            throw new IllegalArgumentException("Given host prefix is either null or empty");
        }
        Matcher matcher = PATTERN.matcher(hostExpression);
        while (matcher.find()) {
            String matched = matcher.group(1);
            this.c2jNames.add(matched);
            this.hostWithStringSpecifier = this.hostWithStringSpecifier.replaceFirst("\\{" + matched + "}", "%s");
        }
    }

    public String getHostWithStringSpecifier() {
        return this.hostWithStringSpecifier;
    }

    public List<String> getC2jNames() {
        return this.c2jNames;
    }
}

