/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.codegen.emitters.tasks;

import com.amazonaws.codegen.emitters.FreemarkerGeneratorTask;
import com.amazonaws.codegen.emitters.GeneratorTask;
import com.amazonaws.codegen.emitters.GeneratorTaskParams;
import com.amazonaws.codegen.emitters.tasks.BaseGeneratorTasks;
import com.amazonaws.util.ImmutableMapParameter;
import java.util.Collections;
import java.util.List;

public class BaseExceptionClassGeneratorTasks
extends BaseGeneratorTasks {
    private final String modelClassDir;

    public BaseExceptionClassGeneratorTasks(GeneratorTaskParams dependencies) {
        super(dependencies);
        this.modelClassDir = dependencies.getPathProvider().getModelDirectory();
    }

    @Override
    protected boolean hasTasks() {
        return this.model.getCustomizationConfig().getSdkModeledExceptionBaseClassName() == null;
    }

    @Override
    protected List<GeneratorTask> createTasks() throws Exception {
        this.info("Emitting Base Service Exception class");
        String baseClassName = this.model.getSdkModeledExceptionBaseClassName();
        return Collections.singletonList(new FreemarkerGeneratorTask(this.modelClassDir, baseClassName, this.freemarker.getBaseExceptionClassTemplate(), ImmutableMapParameter.of((Object)"fileHeader", (Object)this.model.getFileHeader(), (Object)"className", (Object)baseClassName, (Object)"metadata", (Object)this.model.getMetadata(), (Object)"baseExceptionFqcn", (Object)this.model.getServiceBaseExceptionFqcn())));
    }
}

