/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.codegen.emitters;

import com.amazonaws.codegen.model.intermediate.IntermediateModel;

public class GeneratorPathProvider {
    private final IntermediateModel model;
    private final String outputDirectory;
    private final String sourceDirectory;

    public GeneratorPathProvider(IntermediateModel model, String outputDirectory, String sourceDirectory) {
        this.model = model;
        this.outputDirectory = outputDirectory;
        this.sourceDirectory = sourceDirectory;
    }

    public String getModelDirectory() {
        return this.getBasePackageDirectory() + "/" + "model";
    }

    public String getTransformDirectory() {
        return this.getModelDirectory() + "/" + "transform";
    }

    public String getBasePackageDirectory() {
        return this.sourceDirectory + "/" + this.getPackagePath();
    }

    public String getOutputDirectory() {
        return this.outputDirectory;
    }

    public String getSmokeTestDirectory() {
        return String.format("%s/../%s/%s/%s", this.getOutputDirectory(), "smoketests", this.getPackagePath(), "smoketests");
    }

    public String getWaitersDirectory() {
        return this.getBasePackageDirectory() + "/" + "waiters";
    }

    public String getPolicyEnumDirectory() {
        return this.getOutputDirectory() + "/" + "com/amazonaws/auth/policy/actions";
    }

    private String getPackagePath() {
        return this.model.getMetadata().getPackagePath();
    }
}

