/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.codegen.emitters.tasks;

import com.amazonaws.codegen.emitters.FreemarkerGeneratorTask;
import com.amazonaws.codegen.emitters.GeneratorTask;
import com.amazonaws.codegen.emitters.GeneratorTaskParams;
import com.amazonaws.codegen.emitters.tasks.BaseGeneratorTasks;
import com.amazonaws.codegen.model.intermediate.AuthorizerModel;
import com.amazonaws.codegen.model.intermediate.Metadata;
import com.amazonaws.codegen.utils.FunctionalUtils;
import com.amazonaws.util.ImmutableMapParameter;
import java.util.List;
import java.util.stream.Collectors;

public class AuthorizerGeneratorTasks
extends BaseGeneratorTasks {
    private final String customRequestSignerDir;

    public AuthorizerGeneratorTasks(GeneratorTaskParams dependencies) {
        super(dependencies);
        this.customRequestSignerDir = dependencies.getPathProvider().getAuthorizerDirectory();
    }

    @Override
    protected boolean hasTasks() {
        return !this.model.getCustomAuthorizers().isEmpty();
    }

    @Override
    protected List<GeneratorTask> createTasks() throws Exception {
        this.info("Emitting Authorizer interfaces");
        return this.model.getCustomAuthorizers().values().stream().map(FunctionalUtils.safeFunction(this::createTask)).collect(Collectors.toList());
    }

    private GeneratorTask createTask(AuthorizerModel customAuthorizer) throws Exception {
        Metadata metadata = this.model.getMetadata();
        ImmutableMapParameter dataModel = ImmutableMapParameter.of((Object)"fileHeader", (Object)this.model.getFileHeader(), (Object)"className", (Object)customAuthorizer.getInterfaceName(), (Object)"authorizer", (Object)customAuthorizer, (Object)"metadata", (Object)metadata);
        return new FreemarkerGeneratorTask(this.customRequestSignerDir, customAuthorizer.getInterfaceName(), this.freemarker.getCustomAuthorizerTemplate(), dataModel);
    }
}

