/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.codegen.model.intermediate;

import com.amazonaws.codegen.internal.Utils;
import com.amazonaws.codegen.model.config.customization.CustomizationConfig;
import com.amazonaws.codegen.model.intermediate.AuthorizerModel;
import com.amazonaws.codegen.model.intermediate.Metadata;
import com.amazonaws.codegen.model.intermediate.OperationModel;
import com.amazonaws.codegen.model.intermediate.Protocol;
import com.amazonaws.codegen.model.intermediate.ServiceExamples;
import com.amazonaws.codegen.model.intermediate.ShapeModel;
import com.amazonaws.codegen.model.intermediate.WaiterDefinitionModel;
import com.amazonaws.util.IOUtils;
import com.amazonaws.util.ValidationUtils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import org.joda.time.DateTime;

public class IntermediateModel {
    private static final String DEFAULT_CLIENT_CONFIG_FACTORY = "ClientConfigurationFactory";
    private final Metadata metadata;
    private final Map<String, OperationModel> operations;
    private final Map<String, ShapeModel> shapes;
    private final CustomizationConfig customizationConfig;
    private final ServiceExamples examples;
    @JsonIgnore
    private final Map<String, AuthorizerModel> customAuthorizers;
    @JsonIgnore
    private final OperationModel endpointOperation;
    @JsonIgnore
    private final Map<String, WaiterDefinitionModel> waiters;

    @JsonCreator
    public IntermediateModel(@JsonProperty(value="metadata") Metadata metadata, @JsonProperty(value="operations") Map<String, OperationModel> operations, @JsonProperty(value="shapes") Map<String, ShapeModel> shapes, @JsonProperty(value="customizationConfig") CustomizationConfig customizationConfig, @JsonProperty(value="serviceExamples") ServiceExamples examples) {
        this(metadata, operations, shapes, customizationConfig, examples, null, Collections.emptyMap(), Collections.emptyMap());
    }

    public IntermediateModel(Metadata metadata, Map<String, OperationModel> operations, Map<String, ShapeModel> shapes, CustomizationConfig customizationConfig, ServiceExamples examples, OperationModel endpointOperation, Map<String, WaiterDefinitionModel> waiters, Map<String, AuthorizerModel> customAuthorizers) {
        this.metadata = metadata;
        this.operations = operations;
        this.shapes = shapes;
        this.customizationConfig = customizationConfig;
        this.examples = examples;
        this.endpointOperation = endpointOperation;
        this.waiters = (Map)ValidationUtils.assertNotNull(waiters, (String)"waiters");
        this.customAuthorizers = customAuthorizers;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public Map<String, OperationModel> getOperations() {
        return this.operations;
    }

    public OperationModel getOperation(String operationName) {
        return this.getOperations().get(operationName);
    }

    public Map<String, ShapeModel> getShapes() {
        return this.shapes;
    }

    public ShapeModel getShapeByC2jName(String c2jName) {
        return Utils.findShapeModelByC2jName(this, c2jName);
    }

    public CustomizationConfig getCustomizationConfig() {
        return this.customizationConfig;
    }

    public ServiceExamples getExamples() {
        return this.examples;
    }

    public Map<String, WaiterDefinitionModel> getWaiters() {
        return this.waiters;
    }

    public String getClientConfigFactory() {
        if (this.customizationConfig.getCustomClientConfigFactory() == null) {
            return DEFAULT_CLIENT_CONFIG_FACTORY;
        }
        return this.customizationConfig.getCustomClientConfigFactory();
    }

    public String getExceptionUnmarshallerImpl() {
        if (this.customizationConfig.getCustomExceptionUnmarshallerImpl() != null) {
            return this.customizationConfig.getCustomExceptionUnmarshallerImpl();
        }
        return this.metadata.getProtocolDefaultExceptionUmarshallerImpl();
    }

    public String getServiceBaseExceptionFqcn() {
        return this.metadata.getProtocol().getProvider().getBaseExceptionFqcn();
    }

    public String getSdkModeledExceptionBaseFqcn() {
        return String.format("%s.model.%s", this.metadata.getPackageName(), this.getSdkModeledExceptionBaseClassName());
    }

    public String getSdkModeledExceptionBaseClassName() {
        if (this.customizationConfig.getSdkModeledExceptionBaseClassName() != null) {
            return this.customizationConfig.getSdkModeledExceptionBaseClassName();
        }
        return String.format("%sException", this.metadata.getSyncInterface());
    }

    public String getFileHeader() throws IOException {
        if (this.customizationConfig.getCustomFileHeader() != null) {
            return String.format("/**%n%s%n*/", this.customizationConfig.getCustomFileHeader());
        }
        return this.loadDeafultFileHeader();
    }

    private String loadDeafultFileHeader() throws IOException {
        try (InputStream inputStream = this.getClass().getResourceAsStream("/com/amazonaws/codegen/DefaultFileHeader.txt");){
            String string = IOUtils.toString((InputStream)inputStream).replaceFirst("%COPYRIGHT_DATE_RANGE%", this.getCopyrightDateRange());
            return string;
        }
    }

    private String getCopyrightDateRange() {
        int currentYear = DateTime.now().getYear();
        int copyrightStartYear = currentYear - 5;
        return String.format("%d-%d", copyrightStartYear, currentYear);
    }

    public OperationModel getEndpointOperation() {
        return this.endpointOperation;
    }

    public boolean getHasWaiters() {
        return this.waiters.size() > 0;
    }

    public String getSdkBaseResponseFqcn() {
        if (this.metadata.getProtocol() == Protocol.API_GATEWAY) {
            return "com.amazonaws.opensdk.BaseResult";
        }
        return String.format("com.amazonaws.AmazonWebServiceResult<%s>", this.getResponseMetadataClassName());
    }

    private String getResponseMetadataClassName() {
        return this.customizationConfig.getCustomResponseMetadataClassName() == null ? "com.amazonaws.ResponseMetadata" : this.customizationConfig.getCustomResponseMetadataClassName();
    }

    public Map<String, AuthorizerModel> getCustomAuthorizers() {
        return this.customAuthorizers;
    }

    public String getTransformPackage() {
        return this.metadata.getPackageName() + ".model." + Utils.directoryToPackage(this.customizationConfig.getTransformDirectory());
    }
}

