/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.codegen.utils;

import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class CompositeIterable<T>
implements Iterable<T> {
    private Iterable<Iterable<T>> iterables;

    public CompositeIterable(Iterable<Iterable<T>> iterables) {
        this.iterables = iterables;
    }

    @SafeVarargs
    public CompositeIterable(Iterable<T> ... iterables) {
        this.iterables = Arrays.asList(iterables);
    }

    @Override
    public Iterator<T> iterator() {
        return new CompositeIterator();
    }

    private class CompositeIterator
    implements Iterator<T> {
        private Iterator<Iterable<T>> iterableIterator;
        private Iterator<T> currentIterator;

        private CompositeIterator() {
            this.iterableIterator = CompositeIterable.this.iterables.iterator();
        }

        @Override
        public boolean hasNext() {
            if (this.currentIterator != null && this.currentIterator.hasNext()) {
                return true;
            }
            if (this.iterableIterator.hasNext()) {
                this.currentIterator = this.iterableIterator.next().iterator();
                return this.hasNext();
            }
            return false;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.currentIterator.next();
        }
    }
}

