/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.codegen;

import com.amazonaws.codegen.IntermediateModelBuilder;
import com.amazonaws.codegen.IntermediateModelShapeProcessor;
import com.amazonaws.codegen.internal.Utils;
import com.amazonaws.codegen.model.config.customization.CustomizationConfig;
import com.amazonaws.codegen.model.intermediate.OperationModel;
import com.amazonaws.codegen.model.intermediate.ShapeModel;
import com.amazonaws.codegen.model.intermediate.ShapeType;
import com.amazonaws.codegen.model.intermediate.VariableModel;
import com.amazonaws.codegen.model.service.Input;
import com.amazonaws.codegen.model.service.Operation;
import com.amazonaws.codegen.model.service.ServiceModel;
import com.amazonaws.codegen.naming.NamingStrategy;
import java.util.HashMap;
import java.util.Map;

final class AddEmptyInputShape
implements IntermediateModelShapeProcessor {
    private final ServiceModel serviceModel;
    private final NamingStrategy namingStrategy;
    private final CustomizationConfig customizationConfig;

    public AddEmptyInputShape(IntermediateModelBuilder builder) {
        this.serviceModel = builder.getService();
        this.namingStrategy = builder.getNamingStrategy();
        this.customizationConfig = builder.getCustomConfig();
    }

    @Override
    public Map<String, ShapeModel> process(Map<String, OperationModel> currentOperations, Map<String, ShapeModel> currentShapes) {
        if (this.customizationConfig.useModeledOutputShapeNames()) {
            return currentShapes;
        }
        return this.addEmptyInputShapes(currentOperations);
    }

    private Map<String, ShapeModel> addEmptyInputShapes(Map<String, OperationModel> javaOperationMap) {
        Map<String, Operation> operations = this.serviceModel.getOperations();
        HashMap<String, ShapeModel> emptyInputShapes = new HashMap<String, ShapeModel>();
        for (Map.Entry<String, Operation> entry : operations.entrySet()) {
            String operationName = entry.getKey();
            Operation operation = entry.getValue();
            Input input = operation.getInput();
            if (input != null) continue;
            String inputShape = this.namingStrategy.getRequestClassName(operationName);
            OperationModel operationModel = javaOperationMap.get(operationName);
            operationModel.setInput(new VariableModel(Utils.unCapitialize(inputShape), inputShape));
            ShapeModel shape = new ShapeModel(inputShape).withType(ShapeType.Request.getValue());
            shape.setShapeName(inputShape);
            VariableModel inputVariable = new VariableModel(this.namingStrategy.getVariableName(inputShape), inputShape);
            shape.setVariable(inputVariable);
            shape.setMarshaller(Utils.createInputShapeMarshaller(this.serviceModel.getMetadata(), operation));
            emptyInputShapes.put(inputShape, shape);
        }
        return emptyInputShapes;
    }
}

