/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.codegen.naming;

import com.amazonaws.codegen.internal.Utils;
import com.amazonaws.codegen.model.config.BasicCodeGenConfig;
import com.amazonaws.codegen.model.config.customization.CustomizationConfig;
import com.amazonaws.codegen.model.service.Output;
import com.amazonaws.codegen.model.service.ServiceModel;
import com.amazonaws.codegen.naming.NamingStrategy;
import com.amazonaws.util.StringUtils;
import java.util.HashSet;
import java.util.Set;

public class DefaultNamingStrategy
implements NamingStrategy {
    private static final Set<String> reservedKeywords = new HashSet<String>(){
        {
            this.add("return");
            this.add("public");
            this.add("private");
            this.add("class");
            this.add("static");
            this.add("protected");
            this.add("string");
            this.add("boolean");
            this.add("integer");
            this.add("int");
            this.add("char");
            this.add("null");
            this.add("double");
            this.add("object");
            this.add("short");
            this.add("long");
            this.add("float");
            this.add("byte");
            this.add("bigDecimal");
            this.add("bigInteger");
            this.add("protected");
            this.add("inputStream");
            this.add("bytebuffer");
            this.add("date");
            this.add("list");
            this.add("map");
        }
    };
    private final ServiceModel serviceModel;
    private final BasicCodeGenConfig codeGenConfig;
    private final CustomizationConfig customizationConfig;

    public DefaultNamingStrategy(ServiceModel serviceModel, BasicCodeGenConfig codeGenConfig, CustomizationConfig customizationConfig) {
        this.serviceModel = serviceModel;
        this.customizationConfig = customizationConfig;
        this.codeGenConfig = codeGenConfig;
    }

    @Override
    public String getExceptionName(String errorShapeName) {
        if (errorShapeName.endsWith("Fault")) {
            return Utils.capitialize(errorShapeName.substring(0, errorShapeName.length() - "Fault".length()) + "Exception");
        }
        if (errorShapeName.endsWith("Exception")) {
            return Utils.capitialize(errorShapeName);
        }
        return Utils.capitialize(errorShapeName + "Exception");
    }

    @Override
    public String getRequestClassName(String operationName) {
        return Utils.capitialize(operationName + "Request");
    }

    @Override
    public String getResponseClassName(String operationName) {
        Output operationOutput;
        if (this.customizationConfig.useModeledOutputShapeNames() && (operationOutput = this.serviceModel.getOperation(operationName).getOutput()) != null) {
            return operationOutput.getShape();
        }
        return Utils.capitialize(operationName + "Result");
    }

    @Override
    public String getVariableName(String name) {
        if (DefaultNamingStrategy.isJavaKeyword(name)) {
            return Utils.unCapitialize(name + "Value");
        }
        return Utils.unCapitialize(name);
    }

    @Override
    public String getEnumValueName(String enumValue) {
        StringBuilder builder = new StringBuilder();
        String sanitizedEnumValue = enumValue.replace("::", ":").replace("/", "").replace("(", "").replace(")", "");
        for (String part : sanitizedEnumValue.split("[ -.:]")) {
            if (part.length() > 1) {
                builder.append(StringUtils.upperCase((String)part.substring(0, 1))).append(part.substring(1));
                continue;
            }
            builder.append(StringUtils.upperCase((String)part));
        }
        return builder.toString();
    }

    @Override
    public String getJavaClassName(String shapeName) {
        return Utils.capitialize(shapeName);
    }

    private static boolean isJavaKeyword(String word) {
        return reservedKeywords.contains(word) || reservedKeywords.contains(StringUtils.lowerCase((String)word));
    }
}

