/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.codegen;

import com.amazonaws.codegen.AddEmptyInputShape;
import com.amazonaws.codegen.AddEmptyOutputShape;
import com.amazonaws.codegen.AddExceptionShapes;
import com.amazonaws.codegen.AddInputShapes;
import com.amazonaws.codegen.AddMetadata;
import com.amazonaws.codegen.AddModelShapes;
import com.amazonaws.codegen.AddOperations;
import com.amazonaws.codegen.AddOutputShapes;
import com.amazonaws.codegen.IntermediateModelShapeProcessor;
import com.amazonaws.codegen.RemoveUnusedShapes;
import com.amazonaws.codegen.customization.CodegenCustomizationProcessor;
import com.amazonaws.codegen.customization.processors.DefaultCustomizationProcessor;
import com.amazonaws.codegen.internal.TypeUtils;
import com.amazonaws.codegen.internal.Utils;
import com.amazonaws.codegen.model.config.BasicCodeGenConfig;
import com.amazonaws.codegen.model.config.customization.CustomizationConfig;
import com.amazonaws.codegen.model.intermediate.IntermediateModel;
import com.amazonaws.codegen.model.intermediate.MemberModel;
import com.amazonaws.codegen.model.intermediate.OperationModel;
import com.amazonaws.codegen.model.intermediate.ServiceExamples;
import com.amazonaws.codegen.model.intermediate.ShapeModel;
import com.amazonaws.codegen.model.service.Operation;
import com.amazonaws.codegen.model.service.ServiceModel;
import com.amazonaws.codegen.naming.DefaultNamingStrategy;
import com.amazonaws.codegen.naming.NamingStrategy;
import com.amazonaws.util.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class IntermediateModelBuilder {
    private final CustomizationConfig customConfig;
    private final BasicCodeGenConfig codeGenConfig;
    private final ServiceModel service;
    private final ServiceExamples examples;
    private final NamingStrategy namingStrategy;
    private final TypeUtils typeUtils;
    private final List<IntermediateModelShapeProcessor> shapeProcessors;

    public IntermediateModelBuilder(CustomizationConfig customConfig, BasicCodeGenConfig codeGenConfig, ServiceModel service, ServiceExamples examples) {
        this.customConfig = customConfig;
        this.codeGenConfig = codeGenConfig;
        this.service = service;
        this.examples = examples;
        this.namingStrategy = new DefaultNamingStrategy(service, codeGenConfig, customConfig);
        this.typeUtils = new TypeUtils(this.namingStrategy);
        this.shapeProcessors = this.createShapeProcessors();
    }

    private List<IntermediateModelShapeProcessor> createShapeProcessors() {
        ArrayList<IntermediateModelShapeProcessor> processors = new ArrayList<IntermediateModelShapeProcessor>();
        processors.add(new AddInputShapes(this));
        processors.add(new AddOutputShapes(this));
        processors.add(new AddExceptionShapes(this));
        processors.add(new AddModelShapes(this));
        processors.add(new AddEmptyInputShape(this));
        processors.add(new AddEmptyOutputShape(this));
        return processors;
    }

    public IntermediateModel build() {
        CodegenCustomizationProcessor customization = DefaultCustomizationProcessor.getProcessorFor(this.customConfig);
        customization.preprocess(this.service);
        TreeMap<String, OperationModel> operations = new TreeMap<String, OperationModel>();
        HashMap<String, ShapeModel> shapes = new HashMap<String, ShapeModel>();
        operations.putAll(new AddOperations(this).constructOperations());
        for (IntermediateModelShapeProcessor processor : this.shapeProcessors) {
            shapes.putAll(processor.process(Collections.unmodifiableMap(operations), Collections.unmodifiableMap(shapes)));
        }
        System.out.println(shapes.size() + " shapes found in total.");
        IntermediateModel fullModel = new IntermediateModel(AddMetadata.constructMetadata(this.service, this.codeGenConfig, this.customConfig), operations, shapes, this.customConfig, this.examples);
        customization.postprocess(fullModel);
        System.out.println(fullModel.getShapes().size() + " shapes remained after applying customizations.");
        Map<String, ShapeModel> trimmedShapes = RemoveUnusedShapes.removeUnusedShapes(fullModel);
        System.out.println(shapes.size() + " shapes remained after removing unused shapes.");
        IntermediateModel trimmedModel = new IntermediateModel(fullModel.getMetadata(), fullModel.getOperations(), trimmedShapes, fullModel.getCustomizationConfig(), fullModel.getExamples());
        this.linkMembersToShapes(trimmedModel);
        this.linkOperationsToInputOutputShapes(trimmedModel);
        return trimmedModel;
    }

    private void linkMembersToShapes(IntermediateModel model) {
        for (Map.Entry<String, ShapeModel> entry : model.getShapes().entrySet()) {
            if (entry.getValue().getMembers() == null) continue;
            for (MemberModel member : entry.getValue().getMembers()) {
                member.setShape(Utils.findShapeModelByC2jNameIfExists(model, member.getC2jShape()));
            }
        }
    }

    private void linkOperationsToInputOutputShapes(IntermediateModel model) {
        for (Map.Entry<String, OperationModel> entry : model.getOperations().entrySet()) {
            Operation operation = this.service.getOperations().get(entry.getKey());
            if (operation.getInput() != null) {
                String inputShapeName = operation.getInput().getShape();
                entry.getValue().setInputShape(model.getShapeByC2jName(inputShapeName));
            }
            if (operation.getOutput() == null) continue;
            String outputShapeName = operation.getOutput().getShape();
            if (!StringUtils.isNullOrEmpty((String)operation.getOutput().getResultWrapper())) continue;
            entry.getValue().setOutputShape(model.getShapeByC2jName(outputShapeName));
        }
    }

    public CustomizationConfig getCustomConfig() {
        return this.customConfig;
    }

    public BasicCodeGenConfig getCodeGenConfig() {
        return this.codeGenConfig;
    }

    public ServiceModel getService() {
        return this.service;
    }

    public ServiceExamples getExamples() {
        return this.examples;
    }

    public NamingStrategy getNamingStrategy() {
        return this.namingStrategy;
    }

    public TypeUtils getTypeUtils() {
        return this.typeUtils;
    }
}

