/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.codegen.model.intermediate;

import com.amazonaws.codegen.internal.Utils;
import com.amazonaws.codegen.model.config.customization.CustomizationConfig;
import com.amazonaws.codegen.model.intermediate.Metadata;
import com.amazonaws.codegen.model.intermediate.OperationModel;
import com.amazonaws.codegen.model.intermediate.ServiceExamples;
import com.amazonaws.codegen.model.intermediate.ShapeModel;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

public class IntermediateModel {
    private static final String DEFAULT_CLIENT_CONFIG_FACTORY = "ClientConfigurationFactory";
    private final Metadata metadata;
    private final Map<String, OperationModel> operations;
    private final Map<String, ShapeModel> shapes;
    private final CustomizationConfig customizationConfig;
    private final ServiceExamples examples;

    public IntermediateModel(@JsonProperty(value="metadata") Metadata metadata, @JsonProperty(value="operations") Map<String, OperationModel> operations, @JsonProperty(value="shapes") Map<String, ShapeModel> shapes, @JsonProperty(value="customizationConfig") CustomizationConfig customizationConfig, @JsonProperty(value="serviceExamples") ServiceExamples examples) {
        this.metadata = metadata;
        this.operations = operations;
        this.shapes = shapes;
        this.customizationConfig = customizationConfig;
        this.examples = examples;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public Map<String, OperationModel> getOperations() {
        return this.operations;
    }

    public Map<String, ShapeModel> getShapes() {
        return this.shapes;
    }

    public ShapeModel getShapeByC2jName(String c2jName) {
        return Utils.findShapeModelByC2jName(this, c2jName);
    }

    public CustomizationConfig getCustomizationConfig() {
        return this.customizationConfig;
    }

    public ServiceExamples getExamples() {
        return this.examples;
    }

    public String getClientConfigFactory() {
        if (this.customizationConfig.getCustomClientConfigFactory() == null) {
            return DEFAULT_CLIENT_CONFIG_FACTORY;
        }
        return this.customizationConfig.getCustomClientConfigFactory();
    }

    public String getExceptionUnmarshallerImpl() {
        if (this.customizationConfig.getCustomExceptionUnmarshallerImpl() != null) {
            return this.customizationConfig.getCustomExceptionUnmarshallerImpl();
        }
        return this.metadata.getProtocolDefaultExceptionUmarshallerImpl();
    }

    public String getServiceBaseExceptionFqcn() {
        return this.metadata.getProtocol().getProvider().getBaseExceptionFqcn();
    }

    public String getSdkModeledExceptionBaseFqcn() {
        return String.format("%s.model.%s", this.metadata.getPackageName(), this.getSdkModeledExceptionBaseClassName());
    }

    public String getSdkModeledExceptionBaseClassName() {
        if (this.customizationConfig.getSdkModeledExceptionBaseClassName() != null) {
            return this.customizationConfig.getSdkModeledExceptionBaseClassName();
        }
        return String.format("%sException", this.metadata.getSyncInterface());
    }
}

