/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.codegen.customization.processors;

import com.amazonaws.codegen.customization.CodegenCustomizationProcessor;
import com.amazonaws.codegen.model.intermediate.IntermediateModel;
import com.amazonaws.codegen.model.intermediate.MemberModel;
import com.amazonaws.codegen.model.intermediate.ShapeModel;
import com.amazonaws.codegen.model.service.ServiceModel;
import java.util.List;
import java.util.Map;

public final class SupressEnumSetterProcessor
implements CodegenCustomizationProcessor {
    private final Map<String, List<String>> suppressEnumSetterFor;

    public SupressEnumSetterProcessor(Map<String, List<String>> suppressEnumSetterFor) {
        this.suppressEnumSetterFor = suppressEnumSetterFor;
    }

    @Override
    public void preprocess(ServiceModel serviceModel) {
    }

    @Override
    public void postprocess(IntermediateModel intermediateModel) {
        if (this.suppressEnumSetterFor == null || this.suppressEnumSetterFor.isEmpty()) {
            return;
        }
        this.sanityCheck(intermediateModel);
        for (Map.Entry<String, List<String>> entry : this.suppressEnumSetterFor.entrySet()) {
            String shapeName = entry.getKey();
            List<String> members = entry.getValue();
            ShapeModel shapeModel = intermediateModel.getShapes().get(shapeName);
            for (String memberName : members) {
                MemberModel memberModel = shapeModel.getMemberByName(memberName);
                memberModel.setShouldSupressEnumSetter(true);
            }
        }
    }

    private void sanityCheck(IntermediateModel intermediateModel) {
        for (Map.Entry<String, List<String>> entry : this.suppressEnumSetterFor.entrySet()) {
            String shapeName = entry.getKey();
            List<String> members = entry.getValue();
            ShapeModel shapeModel = intermediateModel.getShapes().get(shapeName);
            if (shapeModel == null) {
                throw new IllegalStateException(String.format("Cannot find shape [%s] in the model when processing customization config sendEmptyQueryStringParam.%s", shapeName, shapeName));
            }
            for (String memberName : members) {
                MemberModel memberModel = shapeModel.getMemberByName(memberName);
                if (memberModel != null) continue;
                throw new IllegalStateException(String.format("Cannot find member [%s] in the model when processing customization config sendEmptyQueryStringParam.%s", memberName, shapeName));
            }
        }
    }
}

